/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent.rewriter;


/**
 * Parses looking for a Ticket Param, used in SSO portlets where ticket processing is required
 * Often tickets are added as form parameters and checked on the authentication for better security
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TicketParamRewriter.java 764612 2009-04-13 21:17:59Z taylor $
 */
public class TicketParamRewriter extends BasicRewriter
{    
    private String ticket;
    private String ticketName;

    public String getTicketName() 
    {
        return ticketName;
    }

    public void setTicketName(String ticketName) 
    {
        this.ticketName = ticketName;
    }
    
    public String getTicket() 
    {
		return ticket;
	}

	public void setTicket(String ticket) 
    {
		this.ticket = ticket;
	}
    
    public boolean enterSimpleTagEvent(String tag, MutableAttributes attrs)
    {
        if (tag.equalsIgnoreCase("input"))
        {
            String name = attrs.getValue("name");
            String value = attrs.getValue("value");
            if (name.equals(this.ticketName))
            {
            
            	//System.out.println("*** TICKET attr=" + name + " val = " + value);    
            	setTicket(value);
            }
        }        
        return true;
    }            
}
