/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.PDFStreamParser;

public abstract class BaseParser {
    private static final Log LOG;
    private static final long OBJECT_NUMBER_THRESHOLD = 10000000000L;
    private static final long GENERATION_NUMBER_THRESHOLD = 65535L;
    static final int MAX_LENGTH_LONG;
    private static final Charset ALTERNATIVE_CHARSET;
    private static final int MAX_RECURSION_DEPTH = 500;
    private static final String MAX_RECUSRION_MSG;
    private int recursionDepth = 0;
    private final Map<Long, COSObjectKey> keyCache = new HashMap<Long, COSObjectKey>();
    private final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    protected static final int E = 101;
    protected static final int N = 110;
    protected static final int D = 100;
    protected static final int S = 115;
    protected static final int T = 116;
    protected static final int R = 114;
    protected static final int A = 97;
    protected static final int M = 109;
    protected static final int O = 111;
    protected static final int B = 98;
    protected static final int J = 106;
    public static final String DEF = "def";
    protected static final String ENDOBJ_STRING = "endobj";
    protected static final String ENDSTREAM_STRING = "endstream";
    protected static final String STREAM_STRING = "stream";
    private static final char[] TRUE;
    private static final char[] FALSE;
    private static final char[] NULL;
    protected static final byte ASCII_LF = 10;
    protected static final byte ASCII_CR = 13;
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_NINE = 57;
    private static final byte ASCII_SPACE = 32;
    protected final RandomAccessRead source;
    protected COSDocument document;

    BaseParser(RandomAccessRead pdfSource) {
        this.source = pdfSource;
    }

    private static boolean isHexDigit(char ch) {
        return BaseParser.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    protected COSObjectKey getObjectKey(long num, int gen) {
        long internalHashCode;
        COSObjectKey foundKey;
        if (this.document == null || this.document.getXrefTable().isEmpty()) {
            return new COSObjectKey(num, gen);
        }
        Map<COSObjectKey, Long> xrefTable = this.document.getXrefTable();
        if (xrefTable.size() > this.keyCache.size()) {
            for (COSObjectKey key : xrefTable.keySet()) {
                this.keyCache.putIfAbsent(key.getInternalHash(), key);
            }
        }
        return (foundKey = this.keyCache.get(internalHashCode = COSObjectKey.computeInternalHash(num, gen))) != null ? foundKey : new COSObjectKey(num, gen);
    }

    private COSBase parseCOSDictionaryValue() throws IOException {
        long numOffset = this.source.getPosition();
        COSBase value = this.parseDirObject();
        this.skipSpaces();
        if (!(value instanceof COSNumber) || !this.isDigit()) {
            return value;
        }
        long genOffset = this.source.getPosition();
        COSBase generationNumber = this.parseDirObject();
        this.skipSpaces();
        this.readExpectedChar('R');
        if (!(value instanceof COSInteger)) {
            LOG.error("expected number, actual=" + value + " at offset " + numOffset);
            return COSNull.NULL;
        }
        if (!(generationNumber instanceof COSInteger)) {
            LOG.error("expected number, actual=" + generationNumber + " at offset " + genOffset);
            return COSNull.NULL;
        }
        long objNumber = ((COSInteger)value).longValue();
        if (objNumber <= 0L) {
            LOG.warn("invalid object number value =" + objNumber + " at offset " + numOffset);
            return COSNull.NULL;
        }
        int genNumber = ((COSInteger)generationNumber).intValue();
        if (genNumber < 0) {
            LOG.error("invalid generation number value =" + genNumber + " at offset " + numOffset);
            return COSNull.NULL;
        }
        return this.getObjectFromPool(this.getObjectKey(objNumber, genNumber));
    }

    private COSBase getObjectFromPool(COSObjectKey key) throws IOException {
        if (this.document == null) {
            throw new IOException("object reference " + key + " at offset " + this.source.getPosition() + " in content stream");
        }
        return this.document.getObjectFromPool(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSDictionary parseCOSDictionary(boolean isDirect) throws IOException {
        try {
            ++this.recursionDepth;
            if (this.recursionDepth > 500) {
                throw new IOException(MAX_RECUSRION_MSG);
            }
            this.readExpectedChar('<');
            this.readExpectedChar('<');
            this.skipSpaces();
            COSDictionary obj = new COSDictionary();
            obj.setDirect(isDirect);
            while (true) {
                this.skipSpaces();
                char c = (char)this.source.peek();
                if (c == '>') break;
                if (c == '/') {
                    if (this.parseCOSDictionaryNameValuePair(obj)) continue;
                    COSDictionary cOSDictionary = obj;
                    return cOSDictionary;
                }
                LOG.warn("Invalid dictionary, found: '" + c + "' but expected: '/' at offset " + this.source.getPosition());
                if (!this.readUntilEndOfCOSDictionary()) continue;
                COSDictionary cOSDictionary = obj;
                return cOSDictionary;
            }
            try {
                this.readExpectedChar('>');
                this.readExpectedChar('>');
            }
            catch (IOException exception) {
                LOG.warn("Invalid dictionary, can't find end of dictionary at offset " + this.source.getPosition());
            }
            COSDictionary cOSDictionary = obj;
            return cOSDictionary;
        }
        finally {
            --this.recursionDepth;
        }
    }

    private boolean readUntilEndOfCOSDictionary() throws IOException {
        int c = this.source.read();
        while (c != -1 && c != 47 && c != 62) {
            if (c == 101 && (c = this.source.read()) == 110 && (c = this.source.read()) == 100) {
                boolean isObj;
                c = this.source.read();
                boolean isStream = c == 115 && this.source.read() == 116 && this.source.read() == 114 && this.source.read() == 101 && this.source.read() == 97 && this.source.read() == 109;
                boolean bl = isObj = !isStream && c == 111 && this.source.read() == 98 && this.source.read() == 106;
                if (isStream || isObj) {
                    return true;
                }
            }
            c = this.source.read();
        }
        if (c == -1) {
            return true;
        }
        this.source.rewind(1);
        return false;
    }

    private boolean parseCOSDictionaryNameValuePair(COSDictionary obj) throws IOException {
        COSName key = this.parseCOSName();
        if (key == null || key.getName().isEmpty()) {
            LOG.warn("Empty COSName at offset " + this.source.getPosition());
        }
        COSBase value = this.parseCOSDictionaryValue();
        this.skipSpaces();
        if (value == null) {
            LOG.warn("Bad dictionary declaration at offset " + this.source.getPosition());
            return false;
        }
        if (value instanceof COSInteger && !((COSInteger)value).isValid()) {
            LOG.warn("Skipped out of range number value at offset " + this.source.getPosition());
        } else {
            value.setDirect(true);
            obj.setItem(key, value);
        }
        return true;
    }

    protected void skipWhiteSpaces() throws IOException {
        int whitespace = this.source.read();
        while (32 == whitespace) {
            whitespace = this.source.read();
        }
        if (!this.skipLinebreak(whitespace)) {
            this.source.rewind(1);
        }
    }

    protected boolean skipLinebreak() throws IOException {
        if (!this.skipLinebreak(this.source.read())) {
            this.source.rewind(1);
            return false;
        }
        return true;
    }

    private boolean skipLinebreak(int linebreak) throws IOException {
        if (this.isCR(linebreak)) {
            int next = this.source.read();
            if (!this.isLF(next)) {
                this.source.rewind(1);
            }
        } else if (!this.isLF(linebreak)) {
            return false;
        }
        return true;
    }

    private int checkForEndOfString(int bracesParameter) throws IOException {
        if (bracesParameter == 0) {
            return 0;
        }
        byte[] nextThreeBytes = new byte[3];
        int amountRead = this.source.read(nextThreeBytes);
        if (amountRead > 0) {
            this.source.rewind(amountRead);
        }
        if (amountRead < 3) {
            return bracesParameter;
        }
        if ((nextThreeBytes[0] == 13 || nextThreeBytes[0] == 10) && (nextThreeBytes[1] == 47 || nextThreeBytes[1] == 62) || nextThreeBytes[0] == 13 && nextThreeBytes[1] == 10 && (nextThreeBytes[2] == 47 || nextThreeBytes[2] == 62)) {
            return 0;
        }
        return bracesParameter;
    }

    protected COSString parseCOSString() throws IOException {
        char nextChar = (char)this.source.read();
        if (nextChar == '<') {
            return this.parseCOSHexString();
        }
        if (nextChar != '(') {
            throw new IOException("parseCOSString string should start with '(' or '<' and not '" + nextChar + "' at offset " + this.source.getPosition());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int braces = 1;
        int c = this.source.read();
        while (braces > 0 && c != -1) {
            char ch = (char)c;
            int nextc = -2;
            if (ch == ')') {
                --braces;
                if ((braces = this.checkForEndOfString(braces)) != 0) {
                    out.write(ch);
                }
            } else if (ch == '(') {
                ++braces;
                out.write(ch);
            } else if (ch == '\\') {
                char next = (char)this.source.read();
                switch (next) {
                    case 'n': {
                        out.write(10);
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        break;
                    }
                    case 't': {
                        out.write(9);
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        break;
                    }
                    case ')': {
                        braces = this.checkForEndOfString(braces);
                        if (braces != 0) {
                            out.write(next);
                            break;
                        }
                        out.write(92);
                        break;
                    }
                    case '(': 
                    case '\\': {
                        out.write(next);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        c = this.source.read();
                        while (this.isEOL(c) && c != -1) {
                            c = this.source.read();
                        }
                        nextc = c;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        StringBuilder octal = new StringBuilder();
                        octal.append(next);
                        c = this.source.read();
                        char digit = (char)c;
                        if (digit >= '0' && digit <= '7') {
                            octal.append(digit);
                            c = this.source.read();
                            digit = (char)c;
                            if (digit >= '0' && digit <= '7') {
                                octal.append(digit);
                            } else {
                                nextc = c;
                            }
                        } else {
                            nextc = c;
                        }
                        int character = 0;
                        try {
                            character = Integer.parseInt(octal.toString(), 8);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Error: Expected octal character, actual='" + octal + "'", e);
                        }
                        out.write(character);
                        break;
                    }
                    default: {
                        out.write(next);
                        break;
                    }
                }
            } else {
                out.write(ch);
            }
            if (nextc != -2) {
                c = nextc;
                continue;
            }
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
        return new COSString(out.toByteArray());
    }

    private COSString parseCOSHexString() throws IOException {
        StringBuilder sBuf;
        block6: {
            int c;
            sBuf = new StringBuilder();
            while (true) {
                if (BaseParser.isHexDigit((char)(c = this.source.read()))) {
                    sBuf.append((char)c);
                    continue;
                }
                if (c == 62) break block6;
                if (c < 0) {
                    throw new IOException("Missing closing bracket for hex string. Reached EOS.");
                }
                if (c != 32 && c != 10 && c != 9 && c != 13 && c != 8 && c != 12) break;
            }
            if (sBuf.length() % 2 != 0) {
                sBuf.deleteCharAt(sBuf.length() - 1);
            }
            while ((c = this.source.read()) != 62 && c >= 0) {
            }
            if (c < 0) {
                throw new IOException("Missing closing bracket for hex string. Reached EOS.");
            }
        }
        return COSString.parseHex(sBuf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSArray parseCOSArray() throws IOException {
        try {
            int i;
            ++this.recursionDepth;
            if (this.recursionDepth > 500) {
                throw new IOException(MAX_RECUSRION_MSG);
            }
            long startPosition = this.source.getPosition();
            this.readExpectedChar('[');
            COSArray po = new COSArray();
            this.skipSpaces();
            while ((i = this.source.peek()) > 0 && (char)i != ']') {
                COSBase pbo = this.parseDirObject();
                if (pbo instanceof COSObject) {
                    pbo = null;
                    if (po.size() > 1 && po.get(po.size() - 1) instanceof COSInteger) {
                        COSInteger genNumber = (COSInteger)po.remove(po.size() - 1);
                        if (po.size() > 0 && po.get(po.size() - 1) instanceof COSInteger) {
                            COSInteger number = (COSInteger)po.remove(po.size() - 1);
                            if (number.longValue() >= 0L && genNumber.intValue() >= 0) {
                                COSObjectKey key = this.getObjectKey(number.longValue(), genNumber.intValue());
                                pbo = this.getObjectFromPool(key);
                            } else {
                                LOG.warn("Invalid value(s) for an object key " + number.longValue() + " " + genNumber.intValue());
                            }
                        }
                    }
                }
                if (pbo == null) {
                    COSArray cOSArray;
                    LOG.warn("Corrupt array element at offset " + this.source.getPosition() + ", start offset: " + startPosition);
                    String isThisTheEnd = this.readString();
                    if (isThisTheEnd.isEmpty() && this.source.peek() == 91) {
                        cOSArray = po;
                        return cOSArray;
                    }
                    this.source.rewind(isThisTheEnd.getBytes(StandardCharsets.ISO_8859_1).length);
                    if (ENDOBJ_STRING.equals(isThisTheEnd) || ENDSTREAM_STRING.equals(isThisTheEnd)) {
                        cOSArray = po;
                        return cOSArray;
                    }
                } else {
                    po.add(pbo);
                }
                this.skipSpaces();
            }
            this.source.read();
            this.skipSpaces();
            COSArray cOSArray = po;
            return cOSArray;
        }
        finally {
            --this.recursionDepth;
        }
    }

    protected boolean isEndOfName(int ch) {
        switch (ch) {
            case -1: 
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    protected COSName parseCOSName() throws IOException {
        this.readExpectedChar('/');
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int c = this.source.read();
        while (!this.isEndOfName(c)) {
            int ch = c;
            if (ch == 35) {
                int ch1 = this.source.read();
                int ch2 = this.source.read();
                if (BaseParser.isHexDigit((char)ch1) && BaseParser.isHexDigit((char)ch2)) {
                    String hex = Character.toString((char)ch1) + (char)ch2;
                    try {
                        buffer.write(Integer.parseInt(hex, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error: expected hex digit, actual='" + hex + "'", e);
                    }
                    c = this.source.read();
                    continue;
                }
                if (ch2 == -1 || ch1 == -1) {
                    LOG.error("Premature EOF in BaseParser#parseCOSName");
                    c = -1;
                    break;
                }
                this.source.rewind(1);
                c = ch1;
                buffer.write(ch);
                continue;
            }
            buffer.write(ch);
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
        return COSName.getPDFName(this.decodeBuffer(buffer));
    }

    private String decodeBuffer(ByteArrayOutputStream buffer) throws UnsupportedEncodingException {
        try {
            return this.utf8Decoder.decode(ByteBuffer.wrap(buffer.toByteArray())).toString();
        }
        catch (CharacterCodingException e) {
            LOG.debug("Buffer could not be decoded using StandardCharsets.UTF_8 - trying " + ALTERNATIVE_CHARSET.name(), e);
            return buffer.toString(ALTERNATIVE_CHARSET.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSBase parseDirObject() throws IOException {
        try {
            ++this.recursionDepth;
            if (this.recursionDepth > 500) {
                throw new IOException(MAX_RECUSRION_MSG);
            }
            this.skipSpaces();
            char c = (char)this.source.peek();
            switch (c) {
                case '<': {
                    this.source.read();
                    c = (char)this.source.peek();
                    this.source.rewind(1);
                    COSBase cOSBase = c == '<' ? this.parseCOSDictionary(true) : this.parseCOSString();
                    return cOSBase;
                }
                case '[': {
                    COSArray cOSArray = this.parseCOSArray();
                    return cOSArray;
                }
                case '(': {
                    COSString cOSString = this.parseCOSString();
                    return cOSString;
                }
                case '/': {
                    COSName cOSName = this.parseCOSName();
                    return cOSName;
                }
                case 'n': {
                    this.readExpectedString(NULL, false);
                    COSNull cOSNull = COSNull.NULL;
                    return cOSNull;
                }
                case 't': {
                    this.readExpectedString(TRUE, false);
                    COSBoolean cOSBoolean = COSBoolean.TRUE;
                    return cOSBoolean;
                }
                case 'f': {
                    this.readExpectedString(FALSE, false);
                    COSBoolean cOSBoolean = COSBoolean.FALSE;
                    return cOSBoolean;
                }
                case 'R': {
                    this.source.read();
                    COSObject cOSObject = new COSObject(null);
                    return cOSObject;
                }
                case '\uffff': {
                    COSBase cOSBase = null;
                    return cOSBase;
                }
            }
            if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                COSNumber cOSNumber = this.parseCOSNumber();
                return cOSNumber;
            }
            long startOffset = this.source.getPosition();
            String badString = this.readString();
            if (badString.isEmpty()) {
                int peek = this.source.peek();
                throw new IOException("Unknown dir object c='" + c + "' cInt=" + c + " peek='" + (char)peek + "' peekInt=" + peek + " at offset " + this.source.getPosition() + " (start offset: " + startOffset + ")");
            }
            if (!ENDOBJ_STRING.equals(badString) && !ENDSTREAM_STRING.equals(badString)) {
                LOG.warn("Skipped unexpected dir object = '" + badString + "' at offset " + this.source.getPosition() + " (start offset: " + startOffset + ")");
                COSNull cOSNull = this instanceof PDFStreamParser ? null : COSNull.NULL;
                return cOSNull;
            }
            this.source.rewind(badString.getBytes(StandardCharsets.ISO_8859_1).length);
            COSBase cOSBase = null;
            return cOSBase;
        }
        finally {
            --this.recursionDepth;
        }
    }

    private COSNumber parseCOSNumber() throws IOException {
        char lastc;
        StringBuilder buf = new StringBuilder();
        int ic = this.source.read();
        char c = (char)ic;
        while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'E' || c == 'e') {
            buf.append(c);
            ic = this.source.read();
            c = (char)ic;
        }
        if (ic != -1) {
            this.source.rewind(1);
        }
        if ((lastc = buf.charAt(buf.length() - 1)) == 'e' || lastc == 'E') {
            buf.deleteCharAt(buf.length() - 1);
            this.source.rewind(1);
        }
        return COSNumber.get(buf.toString());
    }

    protected String readString() throws IOException {
        this.skipSpaces();
        StringBuilder buffer = new StringBuilder();
        int c = this.source.read();
        while (!this.isEndOfName(c)) {
            buffer.append((char)c);
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
        return buffer.toString();
    }

    protected final void readExpectedString(char[] expectedString, boolean skipSpaces) throws IOException {
        this.skipSpaces();
        for (char c : expectedString) {
            if (this.source.read() == c) continue;
            throw new IOException("Expected string '" + new String(expectedString) + "' but missed at character '" + c + "' at offset " + this.source.getPosition());
        }
        this.skipSpaces();
    }

    protected void readExpectedChar(char ec) throws IOException {
        char c = (char)this.source.read();
        if (c != ec) {
            throw new IOException("expected='" + ec + "' actual='" + c + "' at offset " + this.source.getPosition());
        }
    }

    @Deprecated
    protected String readString(int length) throws IOException {
        this.skipSpaces();
        int c = this.source.read();
        StringBuilder buffer = new StringBuilder(length);
        while (!BaseParser.isWhitespace(c) && c != -1 && buffer.length() < length && c != 91 && c != 60 && c != 40 && c != 47) {
            buffer.append((char)c);
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
        return buffer.toString();
    }

    protected boolean isClosing() throws IOException {
        return this.source.peek() == 93;
    }

    @Deprecated
    protected boolean isClosing(int c) {
        return c == 93;
    }

    protected String readLine() throws IOException {
        int c;
        if (this.source.isEOF()) {
            throw new IOException("Error: End-of-File, expected line at offset " + this.source.getPosition());
        }
        StringBuilder buffer = new StringBuilder(11);
        while ((c = this.source.read()) != -1 && !this.isEOL(c)) {
            buffer.append((char)c);
        }
        if (this.isCR(c) && this.isLF(this.source.peek())) {
            this.source.read();
        }
        return buffer.toString();
    }

    protected boolean isEOL() throws IOException {
        return this.isEOL(this.source.peek());
    }

    protected boolean isEOF() throws IOException {
        return this.source.isEOF();
    }

    protected boolean isEOL(int c) {
        return this.isLF(c) || this.isCR(c);
    }

    private boolean isLF(int c) {
        return 10 == c;
    }

    private boolean isCR(int c) {
        return 13 == c;
    }

    protected boolean isWhitespace() throws IOException {
        return BaseParser.isWhitespace(this.source.peek());
    }

    protected static boolean isWhitespace(int c) {
        switch (c) {
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    protected boolean isSpace() throws IOException {
        return this.isSpace(this.source.peek());
    }

    protected boolean isSpace(int c) {
        return 32 == c;
    }

    protected boolean isDigit() throws IOException {
        return BaseParser.isDigit(this.source.peek());
    }

    protected static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    protected void skipSpaces() throws IOException {
        int c = this.source.read();
        while (BaseParser.isWhitespace(c) || c == 37) {
            if (c == 37) {
                c = this.source.read();
                while (!this.isEOL(c) && c != -1) {
                    c = this.source.read();
                }
                continue;
            }
            c = this.source.read();
        }
        if (c != -1) {
            this.source.rewind(1);
        }
    }

    protected long readObjectNumber() throws IOException {
        long retval = this.readLong();
        if (retval < 0L || retval >= 10000000000L) {
            throw new IOException("Object Number '" + retval + "' has more than 10 digits or is negative");
        }
        return retval;
    }

    protected int readGenerationNumber() throws IOException {
        int retval = this.readInt();
        if (retval < 0 || (long)retval > 65535L) {
            throw new IOException("Generation Number '" + retval + "' has more than 5 digits");
        }
        return retval;
    }

    protected int readInt() throws IOException {
        this.skipSpaces();
        int retval = 0;
        StringBuilder intBuffer = this.readStringNumber();
        try {
            retval = Integer.parseInt(intBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.source.rewind(intBuffer.toString().getBytes(StandardCharsets.ISO_8859_1).length);
            throw new IOException("Error: Expected an integer type at offset " + this.source.getPosition() + ", instead got '" + intBuffer + "'", e);
        }
        return retval;
    }

    protected long readLong() throws IOException {
        this.skipSpaces();
        long retval = 0L;
        StringBuilder longBuffer = this.readStringNumber();
        try {
            retval = Long.parseLong(longBuffer.toString());
        }
        catch (NumberFormatException e) {
            this.source.rewind(longBuffer.toString().getBytes(StandardCharsets.ISO_8859_1).length);
            throw new IOException("Error: Expected a long type at offset " + this.source.getPosition() + ", instead got '" + longBuffer + "'", e);
        }
        return retval;
    }

    protected final StringBuilder readStringNumber() throws IOException {
        int lastByte;
        StringBuilder buffer = new StringBuilder();
        while ((lastByte = this.source.read()) >= 48 && lastByte <= 57) {
            buffer.append((char)lastByte);
            if (buffer.length() <= MAX_LENGTH_LONG) continue;
            throw new IOException("Number '" + buffer + "' is getting too long, stop reading at offset " + this.source.getPosition());
        }
        if (lastByte != -1) {
            this.source.rewind(1);
        }
        return buffer;
    }

    static {
        Charset cs;
        LOG = LogFactory.getLog(BaseParser.class);
        MAX_LENGTH_LONG = Long.toString(Long.MAX_VALUE).length();
        MAX_RECUSRION_MSG = "Reached maximum recursion depth " + Integer.toString(500);
        String charsetName = "Windows-1252";
        try {
            cs = Charset.forName(charsetName);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            cs = StandardCharsets.ISO_8859_1;
            LOG.warn("Charset is not supported: " + charsetName + ", falling back to " + cs.name(), e);
        }
        ALTERNATIVE_CHARSET = cs;
        TRUE = new char[]{'t', 'r', 'u', 'e'};
        FALSE = new char[]{'f', 'a', 'l', 's', 'e'};
        NULL = new char[]{'n', 'u', 'l', 'l'};
    }
}

