/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.identity;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresCustomIdentityDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresCustomIdentityTable.TABLE}).addIndex(new PostgresIndex[]{PostgresCustomIdentityTable.USERNAME_INDEX}).build();

    public static interface PostgresCustomIdentityTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"custom_identity");
        public static final Field<String> USERNAME = DSL.field((String)"username", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<UUID> ID = DSL.field((String)"id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<String> NAME = DSL.field((String)"name", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<String> EMAIL = DSL.field((String)"email", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<JSON> REPLY_TO = DSL.field((String)"reply_to", (DataType)SQLDataType.JSON.notNull());
        public static final Field<JSON> BCC = DSL.field((String)"bcc", (DataType)SQLDataType.JSON.notNull());
        public static final Field<String> TEXT_SIGNATURE = DSL.field((String)"text_signature", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<String> HTML_SIGNATURE = DSL.field((String)"html_signature", (DataType)SQLDataType.VARCHAR((int)255).notNull());
        public static final Field<Integer> SORT_ORDER = DSL.field((String)"sort_order", (DataType)SQLDataType.INTEGER.notNull());
        public static final Field<Boolean> MAY_DELETE = DSL.field((String)"may_delete", (DataType)SQLDataType.BOOLEAN.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(USERNAME).column(ID).column(NAME).column(EMAIL).column(REPLY_TO).column(BCC).column(TEXT_SIGNATURE).column(HTML_SIGNATURE).column(SORT_ORDER).column(MAY_DELETE).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{USERNAME, ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex USERNAME_INDEX = PostgresIndex.name((String)"custom_identity_username_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USERNAME}));
    }
}

