/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.simulate.Ingest;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DocumentSimulation
implements PlainJsonSerializable {
    private final String id;
    private final String index;
    private final Ingest ingest;
    @Nullable
    private final String parent;
    @Nullable
    private final String routing;
    private final Map<String, JsonData> source;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<DocumentSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DocumentSimulation::setupDocumentSimulationDeserializer);

    private DocumentSimulation(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.ingest = ApiTypeHelper.requireNonNull(builder.ingest, this, "ingest");
        this.parent = builder.parent;
        this.routing = builder.routing;
        this.source = ApiTypeHelper.unmodifiableRequired(builder.source, (Object)this, "source");
        this.type = builder.type;
    }

    public static DocumentSimulation of(Function<Builder, ObjectBuilder<DocumentSimulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final Ingest ingest() {
        return this.ingest;
    }

    @Nullable
    public final String parent() {
        return this.parent;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final Map<String, JsonData> source() {
        return this.source;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_ingest");
        this.ingest.serialize(generator, mapper);
        if (this.parent != null) {
            generator.writeKey("_parent");
            generator.write(this.parent);
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (ApiTypeHelper.isDefined(this.source)) {
            generator.writeKey("_source");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.source.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
    }

    protected static void setupDocumentSimulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::ingest, Ingest._DESERIALIZER, "_ingest");
        op.add(Builder::parent, JsonpDeserializer.stringDeserializer(), "_parent");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::source, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_source");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DocumentSimulation> {
        private String id;
        private String index;
        private Ingest ingest;
        @Nullable
        private String parent;
        @Nullable
        private String routing;
        private Map<String, JsonData> source;
        @Nullable
        private String type;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder ingest(Ingest value) {
            this.ingest = value;
            return this;
        }

        public final Builder ingest(Function<Ingest.Builder, ObjectBuilder<Ingest>> fn) {
            return this.ingest(fn.apply(new Ingest.Builder()).build());
        }

        public final Builder parent(@Nullable String value) {
            this.parent = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder source(Map<String, JsonData> map) {
            this.source = Builder._mapPutAll(this.source, map);
            return this;
        }

        public final Builder source(String key, JsonData value) {
            this.source = Builder._mapPut(this.source, key, value);
            return this;
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        public DocumentSimulation build() {
            this._checkSingleUse();
            return new DocumentSimulation(this);
        }
    }
}

