/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import jakarta.inject.Inject;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.imapserver.netty.IMAPServer;
import org.apache.james.imapserver.netty.IMAPServerFactory;
import reactor.core.publisher.Mono;

public class IMAPHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("IMAPHealthCheck");
    private final IMAPServerFactory imapServerFactory;

    @Inject
    public IMAPHealthCheck(IMAPServerFactory imapServerFactory) {
        this.imapServerFactory = imapServerFactory;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> {
            if (this.isAnyQueueFull()) {
                return Result.degraded((ComponentName)COMPONENT_NAME, (String)"ReactiveThrottler queue is full");
            }
            return Result.healthy((ComponentName)COMPONENT_NAME);
        });
    }

    private boolean isAnyQueueFull() {
        return this.imapServerFactory.getImapServers().stream().anyMatch(IMAPServer::isReactiveThrottlerQueueFull);
    }
}

