/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import javax.inject.Inject;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SystemMessage;
import org.apache.james.imap.processor.base.AbstractProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SystemMessageProcessor
extends AbstractProcessor<SystemMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMessageProcessor.class);
    private final MailboxManager mailboxManager;

    @Inject
    public SystemMessageProcessor(MailboxManager mailboxManager) {
        super(SystemMessage.class);
        this.mailboxManager = mailboxManager;
    }

    @Override
    protected Mono<Void> doProcess(SystemMessage message, ImapProcessor.Responder responder, ImapSession session) {
        switch (message) {
            case FORCE_LOGOUT: {
                this.forceLogout(session);
                break;
            }
            default: {
                LOGGER.info("Unknown system message {}", (Object)message);
            }
        }
        return Mono.empty();
    }

    private void forceLogout(ImapSession imapSession) {
        MailboxSession session = imapSession.getMailboxSession();
        if (session == null) {
            LOGGER.trace("No mailbox session so no force logout needed");
        }
    }

    @Override
    protected MDCBuilder mdc(SystemMessage message) {
        return MDCBuilder.create().addToContext("action", "SYSTEM_MESSAGE").addToContext("message", message.toString());
    }
}

