/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.CompletionStage;

public interface AsyncAutoCloseable
extends AutoCloseable {
    @NonNull
    public CompletionStage<Void> closeFuture();

    default public boolean isClosed() {
        return this.closeFuture().toCompletableFuture().isDone();
    }

    @NonNull
    public CompletionStage<Void> closeAsync();

    @NonNull
    public CompletionStage<Void> forceCloseAsync();

    @Override
    default public void close() {
        BlockingOperation.checkNotDriverThread();
        CompletableFutures.getUninterruptibly(this.closeAsync().toCompletableFuture());
    }
}

