/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.github.fge.lambdas.Throwing;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ByteSourceContent;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageContentNotFoundException;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.VaultConfiguration;
import org.apache.james.vault.search.Query;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RestoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreService.class);
    private static final Predicate<Throwable> CONTENT_NOT_FOUND_PREDICATE = DeletedMessageContentNotFoundException.class::isInstance;
    private final DeletedMessageVault deletedMessageVault;
    private final MailboxManager mailboxManager;
    private final VaultConfiguration vaultConfiguration;

    @Inject
    RestoreService(DeletedMessageVault deletedMessageVault, MailboxManager mailboxManager, VaultConfiguration vaultConfiguration) {
        this.deletedMessageVault = deletedMessageVault;
        this.mailboxManager = mailboxManager;
        this.vaultConfiguration = vaultConfiguration;
    }

    Flux<RestoreResult> restore(Username usernameToRestore, Query searchQuery) throws MailboxException {
        MailboxSession session = this.mailboxManager.createSystemSession(usernameToRestore);
        MessageManager restoreMessageManager = this.restoreMailboxManager(session);
        return Flux.from((Publisher)this.deletedMessageVault.search(usernameToRestore, searchQuery)).flatMap(deletedMessage -> this.appendToMailbox(restoreMessageManager, (DeletedMessage)deletedMessage, session), 16).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
    }

    private Mono<RestoreResult> appendToMailbox(MessageManager restoreMailboxManager, DeletedMessage deletedMessage, MailboxSession session) {
        return Mono.usingWhen(this.messageContent(deletedMessage), inputStream -> Mono.usingWhen((Publisher)Mono.fromCallable(() -> ByteSourceContent.of((InputStream)inputStream)), content -> Mono.from((Publisher)restoreMailboxManager.appendMessageReactive(MessageManager.AppendCommand.builder().build((Content)content), session)).map(any -> RestoreResult.RESTORE_SUCCEED), content -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> ((ByteSourceContent)content).close()))), stream -> Mono.fromRunnable((Runnable)Throwing.runnable(stream::close))).onErrorResume(throwable -> {
            LOGGER.error("append message {} to restore mailbox of user {} didn't success", new Object[]{deletedMessage.getMessageId().serialize(), deletedMessage.getOwner().asString(), throwable});
            return Mono.just((Object)((Object)RestoreResult.RESTORE_FAILED));
        });
    }

    private Mono<InputStream> messageContent(DeletedMessage deletedMessage) {
        return Mono.from((Publisher)this.deletedMessageVault.loadMimeMessage(deletedMessage.getOwner(), deletedMessage.getMessageId())).onErrorResume(CONTENT_NOT_FOUND_PREDICATE, throwable -> {
            LOGGER.info("Error happened when loading mime message associated with id {} of user {} in the vault", new Object[]{deletedMessage.getMessageId().serialize(), deletedMessage.getOwner().asString(), throwable});
            return Mono.empty();
        });
    }

    private MessageManager restoreMailboxManager(MailboxSession session) throws MailboxException {
        MailboxPath restoreMailbox = MailboxPath.forUser((Username)session.getUser(), (String)this.vaultConfiguration.getRestoreLocation());
        try {
            return this.mailboxManager.getMailbox(restoreMailbox, session);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.debug("mailbox {} doesn't exist, create a new one", (Object)restoreMailbox);
            return this.createRestoreMailbox(session, restoreMailbox);
        }
    }

    private MessageManager createRestoreMailbox(MailboxSession session, MailboxPath restoreMailbox) throws MailboxException {
        return (MessageManager)this.mailboxManager.createMailbox(restoreMailbox, session).map(Throwing.function(mailboxId -> this.mailboxManager.getMailbox(mailboxId, session)).sneakyThrow()).orElseThrow(() -> new RuntimeException("createMailbox " + restoreMailbox.asString() + " returns an empty mailboxId"));
    }

    static enum RestoreResult {
        RESTORE_SUCCEED,
        RESTORE_FAILED;

    }
}

