/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.google.common.base.Strings;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.mailet.MailetConfig;

public class MailetUtil {
    public static String normalizeSubject(String subj, String prefix) {
        StringBuilder subject = new StringBuilder(subj);
        int prefixLength = prefix.length();
        int index = subject.indexOf(prefix);
        if (index != 0) {
            if (index > 0) {
                subject.delete(index, index + prefixLength);
            }
            subject.insert(0, prefix);
        }
        String match = "Re:";
        index = subject.indexOf(match, prefixLength);
        while (index > -1) {
            subject.replace(index, index + match.length(), "RE:");
            index = subject.indexOf(match, prefixLength);
        }
        match = "RE:";
        int indexRE = subject.indexOf(match, prefixLength) + match.length();
        index = subject.indexOf(match, indexRE);
        while (index > 0) {
            subject.delete(index, index + match.length());
            index = subject.indexOf(match, indexRE);
        }
        match = "  ";
        index = subject.indexOf(match, prefixLength);
        while (index > -1) {
            subject.replace(index, index + match.length(), " ");
            index = subject.indexOf(match, prefixLength);
        }
        return subject.toString();
    }

    public static Optional<Boolean> getInitParameter(MailetConfig config, String name) {
        String value = config.getInitParameter(name);
        if ("true".equalsIgnoreCase(value)) {
            return Optional.of(true);
        }
        if ("false".equalsIgnoreCase(value)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition, int defaultValue) throws MessagingException {
        String defaultStringValue = String.valueOf(defaultValue);
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.of(defaultStringValue));
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition) throws MessagingException {
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.empty());
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition, Optional<String> defaultValue) throws MessagingException {
        String value = Optional.ofNullable(condition).orElse(defaultValue.orElse(null));
        if (Strings.isNullOrEmpty(value)) {
            throw new MessagingException("Condition is required. It should be a strictly positive integer");
        }
        int valueAsInt = MailetUtil.tryParseInteger(value);
        if (valueAsInt < 1) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + value);
        }
        return valueAsInt;
    }

    private static int tryParseInteger(String value) throws MessagingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + value);
        }
    }
}

