/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.message.BytesBackedLiteral;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;

public class NettyImapRequestLineReader
extends AbstractNettyImapRequestLineReader {
    private final ChannelBuffer buffer;
    private int read = 0;
    private final int maxLiteralSize;
    private final int maxFrameLength;

    public NettyImapRequestLineReader(Channel channel, ChannelBuffer buffer, boolean retry, int maxLiteralSize, int maxFrameLength) {
        super(channel, retry);
        this.buffer = buffer;
        this.maxLiteralSize = maxLiteralSize;
        this.maxFrameLength = maxFrameLength;
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            byte next;
            if (this.buffer.readable()) {
                next = this.buffer.readByte();
                ++this.read;
                if (this.read > this.maxFrameLength) {
                    throw new DecodingException(HumanReadableText.FAILED, "Line length exceeded.");
                }
            } else {
                throw new NotEnoughDataException();
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    public Literal read(int size, boolean extraCRLF) throws DecodingException {
        int crlf = 0;
        if (extraCRLF) {
            crlf = 2;
        }
        if (this.maxLiteralSize > 0 && size > this.maxLiteralSize) {
            throw new DecodingException(HumanReadableText.FAILED, "Specified literal is greater then the allowed size");
        }
        if (size + crlf > this.buffer.readableBytes()) {
            throw new NotEnoughDataException(size + this.read + crlf);
        }
        this.nextSeen = false;
        this.nextChar = '\u0000';
        try {
            BoundedInputStream in = new BoundedInputStream((InputStream)new ChannelBufferInputStream(this.buffer), (long)size);
            if (extraCRLF) {
                return BytesBackedLiteral.copy((InputStream)new EolInputStream((ImapRequestLineReader)this, (InputStream)in));
            }
            return BytesBackedLiteral.copy((InputStream)in);
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Can not read literal", (Throwable)e);
        }
    }

    public static final class NotEnoughDataException
    extends RuntimeException {
        public static final int UNKNOWN_SIZE = -1;
        private final int size;

        public NotEnoughDataException(int size) {
            this.size = size;
        }

        public NotEnoughDataException() {
            this(-1);
        }

        public int getNeededSize() {
            return this.size;
        }
    }
}

