/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.apache.james.adapter.mailbox.UserRepositoryAuthenticator;
import org.apache.james.adapter.mailbox.UserRepositoryAuthorizator;
import org.apache.james.events.EventListener;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.jpa.JPAAttachmentContentLoader;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.openjpa.OpenJPAMailboxManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreSubscriptionManager;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.NaiveThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.user.SubscriptionMapperFactory;
import org.apache.james.modules.data.JPAEntityManagerModule;
import org.apache.james.modules.mailbox.JPAQuotaSearchModule;
import org.apache.james.modules.mailbox.JpaQuotaModule;
import org.apache.james.utils.MailboxManagerDefinition;
import org.apache.mailbox.tools.indexer.ReIndexerImpl;

public class JPAMailboxModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new JpaQuotaModule());
        this.install((Module)new JPAQuotaSearchModule());
        this.install((Module)new JPAEntityManagerModule());
        this.bind(JPAMailboxSessionMapperFactory.class).in(Scopes.SINGLETON);
        this.bind(OpenJPAMailboxManager.class).in(Scopes.SINGLETON);
        this.bind(JVMMailboxPathLocker.class).in(Scopes.SINGLETON);
        this.bind(StoreSubscriptionManager.class).in(Scopes.SINGLETON);
        this.bind(JPAModSeqProvider.class).in(Scopes.SINGLETON);
        this.bind(JPAUidProvider.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthenticator.class).in(Scopes.SINGLETON);
        this.bind(UserRepositoryAuthorizator.class).in(Scopes.SINGLETON);
        this.bind(JPAId.Factory.class).in(Scopes.SINGLETON);
        this.bind(UnionMailboxACLResolver.class).in(Scopes.SINGLETON);
        this.bind(DefaultMessageId.Factory.class).in(Scopes.SINGLETON);
        this.bind(NaiveThreadIdGuessingAlgorithm.class).in(Scopes.SINGLETON);
        this.bind(ReIndexerImpl.class).in(Scopes.SINGLETON);
        this.bind(SessionProviderImpl.class).in(Scopes.SINGLETON);
        this.bind(SubscriptionMapperFactory.class).to(JPAMailboxSessionMapperFactory.class);
        this.bind(MessageMapperFactory.class).to(JPAMailboxSessionMapperFactory.class);
        this.bind(MailboxMapperFactory.class).to(JPAMailboxSessionMapperFactory.class);
        this.bind(MailboxSessionMapperFactory.class).to(JPAMailboxSessionMapperFactory.class);
        this.bind(MessageId.Factory.class).to(DefaultMessageId.Factory.class);
        this.bind(ThreadIdGuessingAlgorithm.class).to(NaiveThreadIdGuessingAlgorithm.class);
        this.bind(ModSeqProvider.class).to(JPAModSeqProvider.class);
        this.bind(UidProvider.class).to(JPAUidProvider.class);
        this.bind(SubscriptionManager.class).to(StoreSubscriptionManager.class);
        this.bind(MailboxPathLocker.class).to(JVMMailboxPathLocker.class);
        this.bind(Authenticator.class).to(UserRepositoryAuthenticator.class);
        this.bind(MailboxManager.class).to(OpenJPAMailboxManager.class);
        this.bind(StoreMailboxManager.class).to(OpenJPAMailboxManager.class);
        this.bind(SessionProvider.class).to(SessionProviderImpl.class);
        this.bind(Authorizator.class).to(UserRepositoryAuthorizator.class);
        this.bind(MailboxId.Factory.class).to(JPAId.Factory.class);
        this.bind(MailboxACLResolver.class).to(UnionMailboxACLResolver.class);
        this.bind(AttachmentContentLoader.class).to(JPAAttachmentContentLoader.class);
        this.bind(ReIndexer.class).to(ReIndexerImpl.class);
        Multibinder.newSetBinder((Binder)this.binder(), MailboxManagerDefinition.class).addBinding().to(JPAMailboxManagerDefinition.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.GroupEventListener.class).addBinding().to(MailboxAnnotationListener.class);
        this.bind(MailboxManager.class).annotatedWith((Annotation)Names.named((String)"mailboxmanager")).to(MailboxManager.class);
        this.bind(MailboxManagerConfiguration.class).toInstance((Object)MailboxManagerConfiguration.DEFAULT);
    }

    @Singleton
    private static class JPAMailboxManagerDefinition
    extends MailboxManagerDefinition {
        @Inject
        private JPAMailboxManagerDefinition(OpenJPAMailboxManager manager) {
            super("jpa-mailboxmanager", (MailboxManager)manager);
        }
    }
}

