/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Iterables {
    public static <T> Iterable<T> concat(Iterable<T> ... inputs) {
        Objects.requireNonNull(inputs);
        return new ConcatenatedIterable<T>(inputs);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends Iterable<T>> inputs) {
        Objects.requireNonNull(inputs);
        return new FlattenedIterables(inputs);
    }

    public static <T> T get(Iterable<T> iterable, int position) {
        Objects.requireNonNull(iterable);
        if (position < 0) {
            throw new IllegalArgumentException("position >= 0");
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (position >= list.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(position));
            }
            return (T)list.get(position);
        }
        Iterator<T> it = iterable.iterator();
        for (int index = 0; index < position; ++index) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException(Integer.toString(position));
            }
            it.next();
        }
        if (!it.hasNext()) {
            throw new IndexOutOfBoundsException(Integer.toString(position));
        }
        return it.next();
    }

    public static long size(Iterable<?> iterable) {
        return StreamSupport.stream(iterable.spliterator(), true).count();
    }

    static class ConcatenatedIterable<T>
    implements Iterable<T> {
        private final Iterable<T>[] inputs;

        ConcatenatedIterable(Iterable<T>[] inputs) {
            this.inputs = Arrays.copyOf(inputs, inputs.length);
        }

        @Override
        public Iterator<T> iterator() {
            return Stream.of(this.inputs).map(it -> StreamSupport.stream(it.spliterator(), false)).reduce(Stream::concat).orElseGet(Stream::empty).iterator();
        }
    }

    static class FlattenedIterables<T>
    implements Iterable<T> {
        private final Iterable<? extends Iterable<T>> inputs;

        FlattenedIterables(Iterable<? extends Iterable<T>> inputs) {
            ArrayList<Iterable<T>> list = new ArrayList<Iterable<T>>();
            for (Iterable<T> iterable : inputs) {
                list.add(iterable);
            }
            this.inputs = list;
        }

        @Override
        public Iterator<T> iterator() {
            return StreamSupport.stream(this.inputs.spliterator(), false).flatMap(s -> StreamSupport.stream(s.spliterator(), false)).iterator();
        }
    }
}

