/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import com.ibm.icu.text.UnicodeSet;
import java.io.Serializable;
import java.util.Locale;
import javax.mail.Flags;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.jmap.mail.Keyword;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class Keyword$
implements Serializable {
    public static final Keyword$ MODULE$ = new Keyword$();
    private static final int FLAG_NAME_MIN_LENGTH = 1;
    private static final int FLAG_NAME_MAX_LENGTH = 255;
    private static final String VALIDATION_MESSAGE = "FlagName must not be null or empty, must have length form 1-255,must not contain characters with hex from '\\u0000' to '\\u00019' or {'(' ')' '{' ']' '%' '*' '\"' '\\'} ";
    private static final UnicodeSet FLAG_NAME_PATTERN = new UnicodeSet("[[a-z][A-Z][0-9]$_-]").freeze();
    private static final String DRAFT = ((Keyword)MODULE$.of("$draft").get()).flagName();
    private static final String SEEN = ((Keyword)MODULE$.of("$seen").get()).flagName();
    private static final String FLAGGED = ((Keyword)MODULE$.of("$flagged").get()).flagName();
    private static final String ANSWERED = ((Keyword)MODULE$.of("$answered").get()).flagName();
    private static final String DELETED = ((Keyword)MODULE$.of("$deleted").get()).flagName();
    private static final String RECENT = ((Keyword)MODULE$.of("$recent").get()).flagName();
    private static final String FORWARDED = ((Keyword)MODULE$.of("$forwarded").get()).flagName();
    private static final boolean FLAG_VALUE = true;
    private static final List<Keyword> NON_EXPOSED_IMAP_KEYWORDS = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Keyword[]{new Keyword(MODULE$.RECENT()), new Keyword(MODULE$.DELETED())}));
    private static final Map<Flags.Flag, Keyword> IMAP_SYSTEM_FLAGS = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.DRAFT), (Object)new Keyword(MODULE$.DRAFT())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.SEEN), (Object)new Keyword(MODULE$.SEEN())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.FLAGGED), (Object)new Keyword(MODULE$.FLAGGED())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.ANSWERED), (Object)new Keyword(MODULE$.ANSWERED())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.RECENT), (Object)new Keyword(MODULE$.RECENT())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Flags.Flag.DELETED), (Object)new Keyword(MODULE$.DELETED()))}));

    private int FLAG_NAME_MIN_LENGTH() {
        return FLAG_NAME_MIN_LENGTH;
    }

    private int FLAG_NAME_MAX_LENGTH() {
        return FLAG_NAME_MAX_LENGTH;
    }

    private String VALIDATION_MESSAGE() {
        return VALIDATION_MESSAGE;
    }

    private UnicodeSet FLAG_NAME_PATTERN() {
        return FLAG_NAME_PATTERN;
    }

    public String DRAFT() {
        return DRAFT;
    }

    public String SEEN() {
        return SEEN;
    }

    public String FLAGGED() {
        return FLAGGED;
    }

    public String ANSWERED() {
        return ANSWERED;
    }

    public String DELETED() {
        return DELETED;
    }

    public String RECENT() {
        return RECENT;
    }

    public String FORWARDED() {
        return FORWARDED;
    }

    public boolean FLAG_VALUE() {
        return FLAG_VALUE;
    }

    private List<Keyword> NON_EXPOSED_IMAP_KEYWORDS() {
        return NON_EXPOSED_IMAP_KEYWORDS;
    }

    private Map<Flags.Flag, Keyword> IMAP_SYSTEM_FLAGS() {
        return IMAP_SYSTEM_FLAGS;
    }

    public Either<String, Keyword> parse(String flagName) {
        return package$.MODULE$.Either().cond(this.isValid(flagName), (Function0 & Serializable)() -> new Keyword(flagName.toLowerCase(Locale.US)), (Function0 & Serializable)() -> MODULE$.VALIDATION_MESSAGE());
    }

    public Try<Keyword> of(String flagName) {
        Right right;
        String keyword;
        Left left;
        String errorMessage;
        Either<String, Keyword> either = this.parse(flagName);
        if (either instanceof Left && (errorMessage = (String)(left = (Left)either).value()) != null) {
            String string2 = errorMessage;
            return new Failure((Throwable)new IllegalArgumentException(string2));
        }
        if (either instanceof Right && new Keyword(keyword = ((Keyword)(right = (Right)either).value()).flagName()) instanceof Keyword) {
            String string3 = keyword;
            return new Success((Object)new Keyword(string3));
        }
        throw new MatchError(either);
    }

    public Option<Keyword> fromFlag(Flags.Flag flag) {
        return this.IMAP_SYSTEM_FLAGS().get((Object)flag);
    }

    public boolean isValid(String flagName) {
        String string2 = flagName;
        switch (string2 == null ? 0 : string2.hashCode()) {
            default: 
        }
        if (StringUtils.isBlank((CharSequence)flagName)) {
            return false;
        }
        if (flagName.length() < this.FLAG_NAME_MIN_LENGTH() || flagName.length() > this.FLAG_NAME_MAX_LENGTH()) {
            return false;
        }
        return this.FLAG_NAME_PATTERN().containsAll(flagName);
    }

    public String apply(String flagName) {
        return flagName;
    }

    public Option<String> unapply(String x$0) {
        if (new Keyword(x$0) == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Keyword$.class);
    }

    public final String getFlagName$extension(String $this) {
        return $this;
    }

    public final boolean isExposedImapKeyword$extension(String $this) {
        return !this.NON_EXPOSED_IMAP_KEYWORDS().contains((Object)new Keyword($this));
    }

    public final boolean isForbiddenImapKeyword$extension(String $this) {
        return this.NON_EXPOSED_IMAP_KEYWORDS().contains((Object)new Keyword($this));
    }

    public final Option<Flags.Flag> asSystemFlag$extension(String $this) {
        return ((MapOps)this.IMAP_SYSTEM_FLAGS().filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)Keyword$.$anonfun$asSystemFlag$1($this, entry)))).keys().collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Flags.Flag, B1> B1 applyOrElse(A1 flag, Function1<A1, B1> function1) {
                A1 A1 = flag;
                return (B1)flag;
            }

            public final boolean isDefinedAt(Flags.Flag flag) {
                Flags.Flag flag2 = flag;
                return true;
            }
        });
    }

    public final Flags asFlags$extension(String $this) {
        return (Flags)this.asSystemFlag$extension($this).map((Function1 & Serializable)Flag2 -> new Flags(Flag2)).getOrElse((Function0 & Serializable)() -> new Flags($this));
    }

    public final String copy$extension(String $this, String flagName) {
        return flagName;
    }

    public final String copy$default$1$extension(String $this) {
        return $this;
    }

    public final String productPrefix$extension(String $this) {
        return "Keyword";
    }

    public final int productArity$extension(String $this) {
        return 1;
    }

    public final Object productElement$extension(String $this, int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return $this;
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public final boolean canEqual$extension(String $this, Object x$1) {
        return x$1 instanceof String;
    }

    public final String productElementName$extension(String $this, int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "flagName";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public final int hashCode$extension(String $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals$extension(String $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof Keyword)) return false;
        boolean bl = true;
        if (!bl) return false;
        String string2 = x$1 == null ? null : ((Keyword)x$1).flagName();
        String string3 = $this;
        String string4 = string2;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public final String toString$extension(String $this) {
        return ScalaRunTime$.MODULE$._toString((Product)new Keyword($this));
    }

    public static final /* synthetic */ boolean $anonfun$asSystemFlag$1(String $this$1, Tuple2 entry) {
        return entry._2().equals(new Keyword($this$1));
    }

    private Keyword$() {
    }
}

