/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.AggregateId;

public class FilteringAggregateId
implements AggregateId {
    private static final String SEPARATOR = "/";
    private static final String PREFIX = "FilteringRule";
    private final Username username;

    public static FilteringAggregateId parse(String rawString) {
        Preconditions.checkArgument((boolean)rawString.startsWith("FilteringRule/"));
        return new FilteringAggregateId(Username.of((String)rawString.substring(PREFIX.length() + SEPARATOR.length())));
    }

    public FilteringAggregateId(Username username) {
        Preconditions.checkNotNull((Object)username);
        this.username = username;
    }

    public String asAggregateKey() {
        return "FilteringRule/" + this.username.asString();
    }

    public final boolean equals(Object o) {
        if (o instanceof FilteringAggregateId) {
            FilteringAggregateId that = (FilteringAggregateId)o;
            return Objects.equals(this.username, that.username);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.username);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.username).toString();
    }
}

