/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.nio.ByteBuffer;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;

public abstract class SeparatingDataLineFilter
implements DataLineFilter {
    private static final ProtocolSession.AttachmentKey<Boolean> HEADERS_COMPLETE = ProtocolSession.AttachmentKey.of((String)"HEADERS_COMPLETE", Boolean.class);

    @Override
    public final Response onLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        if (!session.getAttachment(HEADERS_COMPLETE, ProtocolSession.State.Transaction).isPresent()) {
            if (line.remaining() == 2) {
                if (line.get() == 13 && line.get() == 10) {
                    line.rewind();
                    Response response = this.onSeparatorLine(session, line, next);
                    session.setAttachment(HEADERS_COMPLETE, Boolean.TRUE, ProtocolSession.State.Transaction);
                    return response;
                }
                line.rewind();
            }
            return this.onHeadersLine(session, line, next);
        }
        return this.onBodyLine(session, line, next);
    }

    protected Response onSeparatorLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }

    protected Response onHeadersLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }

    protected Response onBodyLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        return next.onLine((ProtocolSession)session, line);
    }
}

