/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingAllMailsTaskDTO
implements TaskDTO {
    private final String type;
    private final long repositorySize;
    private final String repositoryPath;
    private final String targetQueue;
    private final boolean consume;
    private final Optional<String> targetProcessor;
    private final Optional<Integer> limit;

    public static TaskDTOModule<ReprocessingAllMailsTask, ReprocessingAllMailsTaskDTO> module(ReprocessingService reprocessingService) {
        return (TaskDTOModule)DTOModule.forDomainObject(ReprocessingAllMailsTask.class).convertToDTO(ReprocessingAllMailsTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(reprocessingService)).toDTOConverter(ReprocessingAllMailsTaskDTO::toDTO).typeName(ReprocessingAllMailsTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    private static ReprocessingAllMailsTaskDTO toDTO(ReprocessingAllMailsTask domainObject, String typeName) {
        try {
            return new ReprocessingAllMailsTaskDTO(typeName, domainObject.getRepositorySize(), domainObject.getRepositoryPath().urlEncoded(), domainObject.getConfiguration().getMailQueueName().asString(), Optional.of(domainObject.getConfiguration().isConsume()), domainObject.getConfiguration().getTargetProcessor(), domainObject.getConfiguration().getLimit().getLimit());
        }
        catch (Exception e) {
            throw new ReprocessingAllMailsTask.UrlEncodingFailureSerializationException(domainObject.getRepositoryPath());
        }
    }

    public ReprocessingAllMailsTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="repositorySize") long repositorySize, @JsonProperty(value="repositoryPath") String repositoryPath, @JsonProperty(value="targetQueue") String targetQueue, @JsonProperty(value="consume") Optional<Boolean> consume, @JsonProperty(value="targetProcessor") Optional<String> targetProcessor, @JsonProperty(value="limit") Optional<Integer> limit) {
        this.type = type;
        this.repositorySize = repositorySize;
        this.repositoryPath = repositoryPath;
        this.targetQueue = targetQueue;
        this.consume = consume.orElse(true);
        this.targetProcessor = targetProcessor;
        this.limit = limit;
    }

    private ReprocessingAllMailsTask fromDTO(ReprocessingService reprocessingService) {
        try {
            return new ReprocessingAllMailsTask(reprocessingService, this.repositorySize, MailRepositoryPath.fromEncoded((String)this.repositoryPath), new ReprocessingService.Configuration(MailQueueName.of((String)this.targetQueue), this.targetProcessor, this.consume, Limit.from(this.limit)));
        }
        catch (Exception e) {
            throw new ReprocessingAllMailsTask.InvalidMailRepositoryPathDeserializationException(this.repositoryPath);
        }
    }

    public String getType() {
        return this.type;
    }

    public long getRepositorySize() {
        return this.repositorySize;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }

    public Optional<Integer> getLimit() {
        return this.limit;
    }
}

