/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.modules.blobstore.validation.StorageStrategyChanged;
import org.apache.james.server.blob.deduplication.StorageStrategy;

class StorageStrategyChangedDTO
implements EventDTO {
    private final int eventId;
    private final String aggregateKey;
    private final String type;
    private final String storageStrategy;

    static StorageStrategyChangedDTO from(StorageStrategyChanged storageStrategyChanged, String type) {
        Preconditions.checkNotNull((Object)storageStrategyChanged);
        StorageStrategy storageStrategy = storageStrategyChanged.getStorageStrategy();
        return new StorageStrategyChangedDTO(storageStrategyChanged.eventId().serialize(), storageStrategyChanged.getAggregateId().asAggregateKey(), type, storageStrategy.name());
    }

    static StorageStrategyChangedDTO from(StorageStrategyChanged storageStrategyChanged) {
        return StorageStrategyChangedDTO.from(storageStrategyChanged, "storage-strategy-changed");
    }

    @JsonCreator
    StorageStrategyChangedDTO(@JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateKey") String aggregateKey, @JsonProperty(value="type") String type, @JsonProperty(value="storageStrategy") String storageStrategy) {
        this.eventId = eventId;
        this.aggregateKey = aggregateKey;
        this.type = type;
        this.storageStrategy = storageStrategy;
    }

    @JsonIgnore
    public StorageStrategyChanged toEvent() {
        return new StorageStrategyChanged(EventId.fromSerialized((int)this.eventId), () -> this.aggregateKey, StorageStrategy.valueOf((String)this.storageStrategy));
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getAggregateKey() {
        return this.aggregateKey;
    }

    public String getType() {
        return this.type;
    }

    public String getStorageStrategy() {
        return this.storageStrategy;
    }

    public final boolean equals(Object o) {
        if (o instanceof StorageStrategyChangedDTO) {
            StorageStrategyChangedDTO that = (StorageStrategyChangedDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.aggregateKey, that.aggregateKey) && Objects.equals(this.type, that.type) && Objects.equals(this.storageStrategy, that.storageStrategy);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.aggregateKey, this.type, this.storageStrategy);
    }
}

