/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import javax.inject.Inject;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.metadata.DeletedMessageIdentifier;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.MetadataDAO;
import org.apache.james.vault.metadata.StorageInformation;
import org.apache.james.vault.metadata.StorageInformationDAO;
import org.apache.james.vault.metadata.UserPerBucketDAO;
import org.reactivestreams.Publisher;

public class CassandraDeletedMessageMetadataVault
implements DeletedMessageMetadataVault {
    private final MetadataDAO metadataDAO;
    private final StorageInformationDAO storageInformationDAO;
    private final UserPerBucketDAO userPerBucketDAO;

    @Inject
    CassandraDeletedMessageMetadataVault(MetadataDAO metadataDAO, StorageInformationDAO storageInformationDAO, UserPerBucketDAO userPerBucketDAO) {
        this.metadataDAO = metadataDAO;
        this.storageInformationDAO = storageInformationDAO;
        this.userPerBucketDAO = userPerBucketDAO;
    }

    public Publisher<Void> store(DeletedMessageWithStorageInformation deletedMessage) {
        BucketName bucketName = deletedMessage.getStorageInformation().getBucketName();
        Username owner = deletedMessage.getDeletedMessage().getOwner();
        MessageId messageId = deletedMessage.getDeletedMessage().getMessageId();
        return this.storageInformationDAO.referenceStorageInformation(owner, messageId, deletedMessage.getStorageInformation()).then(this.metadataDAO.store(deletedMessage)).then(this.userPerBucketDAO.addUser(bucketName, owner));
    }

    public Publisher<Void> removeMetadataRelatedToBucket(BucketName bucketName) {
        return this.userPerBucketDAO.retrieveUsers(bucketName).concatMap(user -> this.metadataDAO.retrieveMessageIds(bucketName, (Username)user).map(messageId -> new DeletedMessageIdentifier((Username)user, (MessageId)messageId)).concatMap(deletedMessageIdentifier -> this.storageInformationDAO.deleteStorageInformation(deletedMessageIdentifier.getOwner(), deletedMessageIdentifier.getMessageId())).then(this.metadataDAO.deleteInBucket(bucketName, (Username)user))).then(this.userPerBucketDAO.deleteBucket(bucketName));
    }

    public Publisher<Void> remove(BucketName bucketName, Username username, MessageId messageId) {
        return this.storageInformationDAO.deleteStorageInformation(username, messageId).then(this.metadataDAO.deleteMessage(bucketName, username, messageId));
    }

    public Publisher<StorageInformation> retrieveStorageInformation(Username username, MessageId messageId) {
        return this.storageInformationDAO.retrieveStorageInformation(username, messageId);
    }

    public Publisher<DeletedMessageWithStorageInformation> listMessages(BucketName bucketName, Username username) {
        return this.metadataDAO.retrieveMetadata(bucketName, username);
    }

    public Publisher<BucketName> listRelatedBuckets() {
        return this.userPerBucketDAO.retrieveBuckets();
    }
}

