/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.es.v7;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.util.Port;

public class ESReporterConfiguration {
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;
    public static final String DEFAULT_INDEX = "james-metrics";
    public static final long DEFAULT_PERIOD_IN_SECOND = 60L;
    private final Optional<String> host;
    private final Optional<Integer> port;
    private final boolean enabled;
    private final Optional<String> index;
    private final Optional<Long> periodInSecond;

    public static Builder builder() {
        return new Builder();
    }

    public ESReporterConfiguration(Optional<String> host, Optional<Integer> port, boolean enabled, Optional<String> index, Optional<Long> periodInSecond) {
        this.host = host;
        this.port = port;
        this.enabled = enabled;
        this.index = index;
        this.periodInSecond = periodInSecond;
    }

    public String getHostWithPort() {
        Preconditions.checkState((boolean)this.host.isPresent());
        Preconditions.checkState((boolean)this.port.isPresent());
        return this.host.get() + ":" + this.port.get();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIndex() {
        return this.index.orElse(DEFAULT_INDEX);
    }

    public long getPeriodInSecond() {
        return this.periodInSecond.orElse(60L);
    }

    public static class Builder {
        private Optional<String> host = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> index = Optional.empty();
        private Optional<Long> periodInSecond = Optional.empty();

        public Builder enabled() {
            this.enabled = Optional.of(true);
            return this;
        }

        public Builder disabled() {
            this.enabled = Optional.of(false);
            return this;
        }

        public Builder onHost(String host, int port) {
            this.host = Optional.of(host);
            this.port = Optional.of(port);
            return this;
        }

        public Builder onIndex(String index) {
            this.index = Optional.ofNullable(index);
            return this;
        }

        public Builder periodInSecond(Long periodInSecond) {
            this.periodInSecond = Optional.ofNullable(periodInSecond);
            return this;
        }

        public ESReporterConfiguration build() {
            Preconditions.checkState((boolean)this.enabled.isPresent(), (Object)"You must specify either enabled or disabled");
            Preconditions.checkState((this.enabled.get() == false || this.host.isPresent() ? 1 : 0) != 0, (Object)"You must specify host when enabled");
            Preconditions.checkState((this.enabled.get() == false || this.port.isPresent() ? 1 : 0) != 0, (Object)"You must specify port when enabled");
            if (this.enabled.get().booleanValue()) {
                Port.assertValid((int)this.port.get());
            }
            return new ESReporterConfiguration(this.host, this.port, this.enabled.get(), this.index, this.periodInSecond);
        }
    }
}

