/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.message.request.SelectRequest;
import org.apache.james.imap.processor.AbstractSelectionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class SelectProcessor
extends AbstractSelectionProcessor<SelectRequest> {
    public SelectProcessor(ImapProcessor next, MailboxManager mailboxManager, EventBus eventBus, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(SelectRequest.class, next, mailboxManager, statusResponseFactory, false, metricFactory, eventBus);
    }

    @Override
    protected Closeable addContextToMDC(SelectRequest message) {
        return MDCBuilder.create().addToContext("action", "SELECT").addToContext("mailbox", message.getMailboxName()).addToContext("condstore", Boolean.toString(message.getCondstore())).addToContextIfPresent("knownModseq", Optional.ofNullable(message.getKnownModSeq()).map(Objects::toString)).addToContext("knownUids", UidRange.toString(message.getKnownUidSet())).addToContext("knownIdRange", IdRange.toString(message.getKnownSequenceSet())).addToContext("lastKnownUidValidity", message.getLastKnownUidValidity().toString()).addToContext("uidSet", UidRange.toString(message.getUidSet())).build();
    }
}

