/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import org.parboiled.Context;
import org.parboiled.ContextAware;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public abstract class BaseActions<V>
implements ContextAware<V> {
    private Context<V> context;

    public Context<V> getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context<V> context) {
        this.context = Preconditions.checkArgNotNull(context, "context");
    }

    public int currentIndex() {
        this.check();
        return this.context.getCurrentIndex();
    }

    public String match() {
        this.check();
        return this.context.getMatch();
    }

    public IndexRange matchRange() {
        this.check();
        return this.context.getMatchRange();
    }

    public String matchOrDefault(String string) {
        this.check();
        String string2 = this.context.getMatch();
        return string2.length() == 0 ? string : string2;
    }

    public char matchedChar() {
        this.check();
        return this.context.getFirstMatchChar();
    }

    public int matchStart() {
        this.check();
        return this.context.getMatchStartIndex();
    }

    public int matchEnd() {
        this.check();
        return this.context.getMatchEndIndex();
    }

    public int matchLength() {
        this.check();
        return this.context.getMatchLength();
    }

    public Position position() {
        this.check();
        return this.context.getPosition();
    }

    public boolean push(V v) {
        this.check();
        this.context.getValueStack().push(v);
        return true;
    }

    public boolean push(int n, V v) {
        this.check();
        this.context.getValueStack().push(n, v);
        return true;
    }

    public boolean pushAll(V v, V ... VArray) {
        this.check();
        this.context.getValueStack().pushAll(v, VArray);
        return true;
    }

    public V pop() {
        this.check();
        return this.context.getValueStack().pop();
    }

    public V pop(int n) {
        this.check();
        return this.context.getValueStack().pop(n);
    }

    public boolean drop() {
        this.check();
        this.context.getValueStack().pop();
        return true;
    }

    public boolean drop(int n) {
        this.check();
        this.context.getValueStack().pop(n);
        return true;
    }

    public V peek() {
        this.check();
        return this.context.getValueStack().peek();
    }

    public V peek(int n) {
        this.check();
        return this.context.getValueStack().peek(n);
    }

    public boolean poke(V v) {
        this.check();
        this.context.getValueStack().poke(v);
        return true;
    }

    public boolean poke(int n, V v) {
        this.check();
        this.context.getValueStack().poke(n, v);
        return true;
    }

    public boolean dup() {
        this.check();
        this.context.getValueStack().dup();
        return true;
    }

    public boolean swap() {
        this.check();
        this.context.getValueStack().swap();
        return true;
    }

    public boolean swap3() {
        this.check();
        this.context.getValueStack().swap3();
        return true;
    }

    public boolean swap4() {
        this.check();
        this.context.getValueStack().swap4();
        return true;
    }

    public boolean swap5() {
        this.check();
        this.context.getValueStack().swap5();
        return true;
    }

    public boolean swap6() {
        this.check();
        this.context.getValueStack().swap6();
        return true;
    }

    public Character currentChar() {
        this.check();
        return Character.valueOf(this.context.getCurrentChar());
    }

    public boolean inPredicate() {
        this.check();
        return this.context.inPredicate();
    }

    public boolean nodeSuppressed() {
        this.check();
        return this.context.isNodeSuppressed();
    }

    public boolean hasError() {
        this.check();
        return this.context.hasError();
    }

    private void check() {
        Checks.ensure(this.context != null && this.context.getMatcher() != null, "Illegal rule definition: Unwrapped action expression!");
    }
}

