/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.mailbox.model.MailboxId;

public class MessageMoves {
    private final ImmutableSet<MailboxId> previousMailboxIds;
    private final ImmutableSet<MailboxId> targetMailboxIds;

    public static Builder builder() {
        return new Builder();
    }

    private MessageMoves(Collection<MailboxId> previousMailboxIds, Collection<MailboxId> targetMailboxIds) {
        this.previousMailboxIds = ImmutableSet.copyOf(previousMailboxIds);
        this.targetMailboxIds = ImmutableSet.copyOf(targetMailboxIds);
    }

    public boolean isChange() {
        return !this.previousMailboxIds.equals(this.targetMailboxIds);
    }

    public Set<MailboxId> addedMailboxIds() {
        return Sets.difference(this.targetMailboxIds, this.previousMailboxIds);
    }

    public Set<MailboxId> removedMailboxIds() {
        return Sets.difference(this.previousMailboxIds, this.targetMailboxIds);
    }

    public ImmutableSet<MailboxId> getPreviousMailboxIds() {
        return this.previousMailboxIds;
    }

    public ImmutableSet<MailboxId> getTargetMailboxIds() {
        return this.targetMailboxIds;
    }

    public Stream<MailboxId> impactedMailboxIds() {
        return Stream.concat(this.addedMailboxIds().stream(), this.removedMailboxIds().stream());
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageMoves) {
            MessageMoves that = (MessageMoves)o;
            return Objects.equals(this.previousMailboxIds, that.previousMailboxIds) && Objects.equals(this.targetMailboxIds, that.targetMailboxIds);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.previousMailboxIds, this.targetMailboxIds);
    }

    public static class Builder {
        private final ImmutableSet.Builder<MailboxId> previousMailboxIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<MailboxId> targetMailboxIds = ImmutableSet.builder();

        private Builder() {
        }

        public Builder previousMailboxIds(Iterable<MailboxId> mailboxIds) {
            this.previousMailboxIds.addAll((Iterable)mailboxIds);
            return this;
        }

        public Builder previousMailboxIds(MailboxId ... mailboxIds) {
            this.previousMailboxIds.addAll(Arrays.asList(mailboxIds));
            return this;
        }

        public Builder targetMailboxIds(Iterable<MailboxId> mailboxIds) {
            this.targetMailboxIds.addAll((Iterable)mailboxIds);
            return this;
        }

        public Builder targetMailboxIds(MailboxId ... mailboxIds) {
            this.targetMailboxIds.addAll(Arrays.asList(mailboxIds));
            return this;
        }

        public MessageMoves build() {
            return new MessageMoves(this.previousMailboxIds.build(), this.targetMailboxIds.build());
        }
    }
}

