/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class Base64InputStreamTest {
    private static Base64InputStream create(String s) {
        return new Base64InputStream(InputStreams.createAscii((CharSequence)s));
    }

    private static Base64InputStream createStrict(String s) {
        return new Base64InputStream(InputStreams.createAscii((CharSequence)s), true);
    }

    private static Base64InputStream create(byte[] b) {
        return new Base64InputStream(InputStreams.create((byte[])b));
    }

    private static byte[] readBin(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    private static String readText(InputStream is) throws IOException {
        return ContentUtil.toAsciiString((byte[])IOUtils.toByteArray((InputStream)is));
    }

    @Test
    public void testDecode() throws IOException {
        int i;
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==");
        Assert.assertEquals((Object)"This is the plain text message!", (Object)Base64InputStreamTest.readText((InputStream)decoder));
        decoder = Base64InputStreamTest.create("VGhpcyBpcyBhIHRleHQgd2hpY2ggaGFzIHRvIGJlIHBhZGRlZCBvbmNlLi4=");
        Assert.assertEquals((Object)"This is a text which has to be padded once..", (Object)Base64InputStreamTest.readText((InputStream)decoder));
        decoder = Base64InputStreamTest.create("VGhpcyBpcyBhIHRleHQgd2hpY2ggaGFzIHRvIGJlIHBhZGRlZCB0d2ljZQ==");
        Assert.assertEquals((Object)"This is a text which has to be padded twice", (Object)Base64InputStreamTest.readText((InputStream)decoder));
        decoder = Base64InputStreamTest.create("VGhpcyBpcyBhIHRleHQgd2hpY2ggd2lsbCBub3QgYmUgcGFkZGVk");
        Assert.assertEquals((Object)"This is a text which will not be padded", (Object)Base64InputStreamTest.readText((InputStream)decoder));
        decoder = Base64InputStreamTest.create(" &% VGhp\r\ncyBp\r\ncyB0aGUgcGxhaW4g  \tdGV4dCBtZ?!XNzY*WdlIQ==");
        Assert.assertEquals((Object)"This is the plain text message!", (Object)Base64InputStreamTest.readText((InputStream)decoder));
        String s1 = "AAECAwQFBgcICQoLDA0ODxAREhMUFRYXGBkaGxwdHh8gISIjJCUmJygpKissLS4vMDEyMzQ1Njc4OTo7PD0+P0BBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWltcXV5fYGFiY2RlZmdoaWprbG1ub3BxcnN0dXZ3eHl6e3x9fn+AgYKDhIWGh4iJiouMjY6PkJGSk5SVlpeYmZqbnJ2en6ChoqOkpaanqKmqq6ytrq+wsbKztLW2t7i5uru8vb6/wMHCw8TFxsfIycrLzM3Oz9DR0tPU1dbX2Nna29zd3t/g4eLj5OXm5+jp6uvs7e7v8PHy8/T19vf4+fr7/P3+/w==";
        String s2 = "AQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGRobHB0eHyAhIiMkJSYnKCkqKywtLi8wMTIzNDU2Nzg5Ojs8PT4/QEFCQ0RFRkdISUpLTE1OT1BRUlNUVVZXWFlaW1xdXl9gYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXp7fH1+f4CBgoOEhYaHiImKi4yNjo+QkZKTlJWWl5iZmpucnZ6foKGio6SlpqeoqaqrrK2ur7CxsrO0tba3uLm6u7y9vr/AwcLDxMXGx8jJysvMzc7P0NHS09TV1tfY2drb3N3e3+Dh4uPk5ebn6Onq6+zt7u/w8fLz9PX29/j5+vv8/f7/AA==";
        String s3 = "AgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fICEiIyQlJicoKSorLC0uLzAxMjM0NTY3ODk6Ozw9Pj9AQUJDREVGR0hJSktMTU5PUFFSU1RVVldYWVpbXF1eX2BhYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5ent8fX5/gIGCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1tre4ubq7vL2+v8DBwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5ufo6err7O3u7/Dx8vP09fb3+Pn6+/z9/v8AAQ==";
        decoder = Base64InputStreamTest.create(s1);
        byte[] bytes = Base64InputStreamTest.readBin((InputStream)decoder);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)bytes[i], (long)((byte)i));
        }
        decoder = Base64InputStreamTest.create(s2);
        bytes = Base64InputStreamTest.readBin((InputStream)decoder);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)bytes[i], (long)((byte)(i + 1)));
        }
        decoder = Base64InputStreamTest.create(s3);
        bytes = Base64InputStreamTest.readBin((InputStream)decoder);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((String)("Position " + i), (long)bytes[i], (long)((byte)(i + 2)));
        }
    }

    @Test
    public void testDecodePrematureClose() throws IOException {
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==");
        Assert.assertEquals((long)84L, (long)decoder.read());
        Assert.assertEquals((long)104L, (long)decoder.read());
        decoder.close();
        try {
            decoder.read();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundtripWithVariousBufferSizes() throws Exception {
        byte[] data = new byte[3719];
        new Random(0L).nextBytes(data);
        ByteArrayOutputStream eOut = new ByteArrayOutputStream();
        EncoderUtil.encodeB((InputStream)InputStreams.create((byte[])data), (OutputStream)eOut);
        byte[] encoded = eOut.toByteArray();
        for (int bufferSize = 1; bufferSize <= 1009; ++bufferSize) {
            int inputLength;
            Base64InputStream decoder = Base64InputStreamTest.create(encoded);
            ByteArrayOutputStream dOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[bufferSize];
            while (-1 != (inputLength = decoder.read(buffer))) {
                dOut.write(buffer, 0, inputLength);
            }
            byte[] decoded = dOut.toByteArray();
            Assert.assertEquals((long)data.length, (long)decoded.length);
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((long)data[i], (long)decoded[i]);
            }
            decoder.close();
        }
    }

    @Test
    public void testReadInt() throws Exception {
        int x;
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((x = decoder.read()) != -1) {
            out.write(x);
        }
        decoder.close();
        Assert.assertEquals((Object)"This is the plain text message!", (Object)ContentUtil.toAsciiString((byte[])out.toByteArray()));
    }

    @Test
    public void testReadOffset() throws Exception {
        int bytes;
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==");
        byte[] data = new byte[36];
        int i = 0;
        while ((bytes = decoder.read(data, i, 5)) != -1) {
            i += bytes;
        }
        decoder.close();
        Assert.assertEquals((Object)"This is the plain text message!\u0000\u0000\u0000\u0000\u0000", (Object)ContentUtil.toAsciiString((byte[])data));
    }

    @Test
    public void testStrictUnexpectedEof() throws Exception {
        Base64InputStream decoder = Base64InputStreamTest.createStrict("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlI");
        try {
            ContentUtil.copy((InputStream)decoder, (OutputStream)new NullOutputStream());
            Assert.fail();
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().toLowerCase().contains("end of base64 stream"));
        }
    }

    @Test
    public void testLenientUnexpectedEof() throws Exception {
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlI");
        byte[] buf = ContentUtil.buffer((InputStream)decoder);
        Assert.assertEquals((Object)"This is the plain text message", (Object)ContentUtil.toAsciiString((byte[])buf));
    }

    @Test
    public void testStrictUnexpectedPad() throws Exception {
        Base64InputStream decoder = Base64InputStreamTest.createStrict("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlI=");
        try {
            ContentUtil.copy((InputStream)decoder, (OutputStream)new NullOutputStream());
            Assert.fail();
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().toLowerCase().contains("pad"));
        }
    }

    @Test
    public void testLenientUnexpectedPad() throws Exception {
        Base64InputStream decoder = Base64InputStreamTest.create("VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlI=");
        byte[] buf = ContentUtil.buffer((InputStream)decoder);
        Assert.assertEquals((Object)"This is the plain text message", (Object)ContentUtil.toAsciiString((byte[])buf));
    }
}

