/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.james.jdkim.canon.AbstractOutputStreamTestCase;
import org.apache.james.jdkim.canon.RelaxedBodyCanonicalizer;

public class RelaxedBodyCanonicalizerTest
extends AbstractOutputStreamTestCase {
    private byte[] testData;
    private byte[] expectedData;

    protected void setUp() throws Exception {
        this.testData = "this  is a \r\n  canonicalization \ttest\r\n\r\n\r\n".getBytes();
        this.expectedData = "this is a\r\n canonicalization test\r\n".getBytes();
    }

    public void testSingleBytes() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RelaxedBodyCanonicalizer os = new RelaxedBodyCanonicalizer((OutputStream)bos);
        for (byte aTestData : this.testData) {
            os.write((int)aTestData);
        }
        os.close();
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }

    public void testChunks() throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RelaxedBodyCanonicalizer os = new RelaxedBodyCanonicalizer((OutputStream)bos);
        this.chunker(this.testData, (OutputStream)os);
        this.assertArrayEquals(this.expectedData, bos.toByteArray());
    }
}

