/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.orc.writer;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.flink.table.store.shaded.org.apache.orc.Writer;
import org.apache.flink.util.Preconditions;

@Internal
public class OrcBulkWriter<T>
implements BulkWriter<T> {
    private final Writer writer;
    private final Vectorizer<T> vectorizer;
    private final VectorizedRowBatch rowBatch;

    OrcBulkWriter(Vectorizer<T> vectorizer, Writer writer) {
        this.vectorizer = Preconditions.checkNotNull(vectorizer);
        this.writer = Preconditions.checkNotNull(writer);
        this.rowBatch = vectorizer.getSchema().createRowBatch();
        this.vectorizer.setWriter(this.writer);
    }

    @Override
    public void addElement(T element) throws IOException {
        this.vectorizer.vectorize(element, this.rowBatch);
        if (this.rowBatch.size == this.rowBatch.getMaxSize()) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.rowBatch.size != 0) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    @Override
    public void finish() throws IOException {
        this.flush();
        this.writer.close();
    }
}

