/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import org.apache.flink.table.store.hive.HiveTypeUtils;
import org.apache.flink.table.store.hive.objectinspector.TableStoreCharObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreDateObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreDecimalObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreListObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreMapObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreStringObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreTimestampObjectInspector;
import org.apache.flink.table.store.hive.objectinspector.TableStoreVarcharObjectInspector;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class TableStoreObjectInspectorFactory {
    public static ObjectInspector create(LogicalType logicalType) {
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: {
                return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)HiveTypeUtils.logicalTypeToTypeInfo(logicalType)));
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return new TableStoreDecimalObjectInspector(decimalType.getPrecision(), decimalType.getScale());
            }
            case CHAR: {
                CharType charType = (CharType)logicalType;
                return new TableStoreCharObjectInspector(charType.getLength());
            }
            case VARCHAR: {
                VarCharType varCharType = (VarCharType)logicalType;
                if (varCharType.getLength() == Integer.MAX_VALUE) {
                    return new TableStoreStringObjectInspector();
                }
                return new TableStoreVarcharObjectInspector(varCharType.getLength());
            }
            case DATE: {
                return new TableStoreDateObjectInspector();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new TableStoreTimestampObjectInspector();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)logicalType;
                return new TableStoreListObjectInspector(arrayType.getElementType());
            }
            case MAP: {
                MapType mapType = (MapType)logicalType;
                return new TableStoreMapObjectInspector(mapType.getKeyType(), mapType.getValueType());
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type " + logicalType.asSummaryString());
    }
}

