/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.store.file.predicate.FieldRef;
import org.apache.flink.table.store.file.predicate.FunctionVisitor;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.NullFalseLeafBinaryFunction;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class StartsWith
extends NullFalseLeafBinaryFunction {
    public static final StartsWith INSTANCE = new StartsWith();

    private StartsWith() {
    }

    @Override
    public boolean test(LogicalType type, Object field, Object patternLiteral) {
        BinaryStringData fieldString = (BinaryStringData)field;
        return fieldString.startsWith((BinaryStringData)patternLiteral);
    }

    @Override
    public boolean test(LogicalType type, long rowCount, FieldStats fieldStats, Object patternLiteral) {
        BinaryStringData min = (BinaryStringData)fieldStats.minValue();
        BinaryStringData max = (BinaryStringData)fieldStats.maxValue();
        BinaryStringData pattern = (BinaryStringData)patternLiteral;
        return !(!min.startsWith(pattern) && min.compareTo(pattern) > 0 || !max.startsWith(pattern) && max.compareTo(pattern) < 0);
    }

    @Override
    public Optional<LeafFunction> negate() {
        return Optional.empty();
    }

    @Override
    public <T> T visit(FunctionVisitor<T> visitor, FieldRef fieldRef, List<Object> literals) {
        return visitor.visitStartsWith(fieldRef, literals.get(0));
    }
}

