/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.manifest.FileKind;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.operation.ScanKind;
import org.apache.flink.table.store.file.predicate.Predicate;

public interface FileStoreScan {
    public FileStoreScan withPartitionFilter(Predicate var1);

    public FileStoreScan withPartitionFilter(List<BinaryRowData> var1);

    public FileStoreScan withBucket(int var1);

    public FileStoreScan withSnapshot(long var1);

    public FileStoreScan withManifestList(List<ManifestFileMeta> var1);

    public FileStoreScan withKind(ScanKind var1);

    public FileStoreScan withLevel(int var1);

    public Plan plan();

    public static interface Plan {
        @Nullable
        public Long snapshotId();

        public List<ManifestEntry> files();

        default public List<ManifestEntry> files(FileKind kind) {
            return this.files().stream().filter(e -> e.kind() == kind).collect(Collectors.toList());
        }

        default public Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupByPartFiles(List<ManifestEntry> files) {
            HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupBy = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
            for (ManifestEntry entry : files) {
                groupBy.computeIfAbsent(entry.partition(), k -> new HashMap()).computeIfAbsent(entry.bucket(), k -> new ArrayList()).add(entry.file());
            }
            return groupBy;
        }
    }
}

