/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.KeyValueFileReaderFactory;
import org.apache.flink.table.store.file.mergetree.DropDeleteReader;
import org.apache.flink.table.store.file.mergetree.SortedRun;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionWrapper;
import org.apache.flink.table.store.file.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.flink.table.store.file.mergetree.compact.SortMergeReader;
import org.apache.flink.table.store.file.utils.RecordReader;

public class MergeTreeReaders {
    private MergeTreeReaders() {
    }

    public static RecordReader<KeyValue> readerForMergeTree(List<List<SortedRun>> sections, boolean dropDelete, KeyValueFileReaderFactory readerFactory, Comparator<RowData> userKeyComparator, MergeFunction<KeyValue> mergeFunction) throws IOException {
        ArrayList readers = new ArrayList();
        for (List<SortedRun> section : sections) {
            readers.add(() -> MergeTreeReaders.readerForSection(section, readerFactory, userKeyComparator, new ReducerMergeFunctionWrapper(mergeFunction)));
        }
        DropDeleteReader reader = ConcatRecordReader.create(readers);
        if (dropDelete) {
            reader = new DropDeleteReader(reader);
        }
        return reader;
    }

    public static RecordReader<KeyValue> readerForSection(List<SortedRun> section, KeyValueFileReaderFactory readerFactory, Comparator<RowData> userKeyComparator, MergeFunctionWrapper<KeyValue> mergeFunctionWrapper) throws IOException {
        ArrayList<RecordReader<KeyValue>> readers = new ArrayList<RecordReader<KeyValue>>();
        for (SortedRun run : section) {
            readers.add(MergeTreeReaders.readerForRun(run, readerFactory));
        }
        if (readers.size() == 1) {
            return (RecordReader)readers.get(0);
        }
        return new SortMergeReader<KeyValue>(readers, userKeyComparator, mergeFunctionWrapper);
    }

    public static RecordReader<KeyValue> readerForRun(SortedRun run, KeyValueFileReaderFactory readerFactory) throws IOException {
        ArrayList readers = new ArrayList();
        for (DataFileMeta file : run.files()) {
            readers.add(() -> readerFactory.createRecordReader(file.schemaId(), file.fileName(), file.level()));
        }
        return ConcatRecordReader.create(readers);
    }
}

