/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.DataFileMeta;
import org.apache.flink.table.store.file.io.StatsCollectingSingleFileWriter;
import org.apache.flink.table.store.file.stats.BinaryTableStats;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.types.logical.RowType;

public class RowDataFileWriter
extends StatsCollectingSingleFileWriter<RowData, DataFileMeta> {
    private final long schemaId;
    private final LongCounter seqNumCounter;
    private final FieldStatsArraySerializer statsArraySerializer;

    public RowDataFileWriter(BulkWriter.Factory<RowData> factory, Path path, RowType writeSchema, @Nullable FileStatsExtractor fileStatsExtractor, long schemaId, LongCounter seqNumCounter) {
        super(factory, path, Function.identity(), writeSchema, fileStatsExtractor);
        this.schemaId = schemaId;
        this.seqNumCounter = seqNumCounter;
        this.statsArraySerializer = new FieldStatsArraySerializer(writeSchema);
    }

    @Override
    public void write(RowData row) throws IOException {
        super.write(row);
        this.seqNumCounter.add(1L);
    }

    @Override
    public DataFileMeta result() throws IOException {
        BinaryTableStats stats = this.statsArraySerializer.toBinary(this.fieldStats());
        return DataFileMeta.forAppend(this.path.getName(), FileUtils.getFileSize(this.path), this.recordCount(), stats, this.seqNumCounter.getLocalValue() - super.recordCount(), this.seqNumCounter.getLocalValue() - 1L, this.schemaId);
    }
}

