/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ValueNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.RawValue;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.functions.SqlJsonUtils;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public class JsonArrayAggFunction
extends BuiltInAggregateFunction<String, Accumulator> {
    private static final long serialVersionUID = 1L;
    private static final StringData NULL_STR = StringData.fromString("null");
    private final transient List<DataType> argumentTypes;
    private final boolean skipNulls;

    public JsonArrayAggFunction(LogicalType[] argumentTypes, boolean skipNulls) {
        this.argumentTypes = Arrays.stream(argumentTypes).map(DataTypeUtils::toInternalDataType).collect(Collectors.toList());
        this.skipNulls = skipNulls;
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return this.argumentTypes;
    }

    @Override
    public DataType getOutputDataType() {
        return DataTypes.STRING();
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(Accumulator.class, DataTypes.FIELD("list", ListView.newListViewDataType(DataTypes.STRING().toInternal())));
    }

    @Override
    public Accumulator createAccumulator() {
        return new Accumulator();
    }

    public void resetAccumulator(Accumulator acc) {
        acc.list.clear();
    }

    public void accumulate(Accumulator acc, StringData itemData) throws Exception {
        if (itemData == null) {
            if (!this.skipNulls) {
                acc.list.add(NULL_STR);
            }
        } else {
            acc.list.add(itemData);
        }
    }

    public void retract(Accumulator acc, StringData itemData) throws Exception {
        if (itemData == null) {
            acc.list.remove(NULL_STR);
        } else {
            acc.list.remove(itemData);
        }
    }

    @Override
    public String getValue(Accumulator acc) {
        ArrayNode rootNode = SqlJsonUtils.createArrayNode();
        try {
            for (StringData item : acc.list.get()) {
                ValueNode itemNode = SqlJsonUtils.getNodeFactory().rawValueNode(new RawValue(item.toString()));
                rootNode.add(itemNode);
            }
        }
        catch (Exception e) {
            throw new TableException("The accumulator state could not be serialized.", e);
        }
        return SqlJsonUtils.serializeJson(rootNode);
    }

    public static class Accumulator {
        public ListView<StringData> list = new ListView();

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Accumulator that = (Accumulator)other;
            return Objects.equals(this.list, that.list);
        }

        public int hashCode() {
            return Objects.hash(this.list);
        }
    }
}

