/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.util.Preconditions;

abstract class AbstractOneInputTransformationTranslator<IN, OUT, OP extends Transformation<OUT>>
extends SimpleTransformationTranslator<OUT, OP> {
    AbstractOneInputTransformationTranslator() {
    }

    protected Collection<Integer> translateInternal(Transformation<OUT> transformation, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<IN> inputType, @Nullable KeySelector<IN, ?> stateKeySelector, @Nullable TypeInformation<?> stateKeyType, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(operatorFactory);
        Preconditions.checkNotNull(inputType);
        Preconditions.checkNotNull(context);
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = transformation.getId();
        ExecutionConfig executionConfig = streamGraph.getExecutionConfig();
        streamGraph.addOperator(transformationId, slotSharingGroup, transformation.getCoLocationGroupKey(), operatorFactory, inputType, transformation.getOutputType(), transformation.getName());
        if (stateKeySelector != null) {
            TypeSerializer<?> keySerializer = stateKeyType.createSerializer(executionConfig);
            streamGraph.setOneInputStateKey(transformationId, stateKeySelector, keySerializer);
        }
        int parallelism = transformation.getParallelism() != -1 ? transformation.getParallelism() : executionConfig.getParallelism();
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, transformation.getMaxParallelism());
        List<Transformation<?>> parentTransformations = transformation.getInputs();
        Preconditions.checkState(parentTransformations.size() == 1, "Expected exactly one input transformation but found " + parentTransformations.size());
        for (Integer inputId : context.getStreamNodeIds(parentTransformations.get(0))) {
            streamGraph.addEdge(inputId, transformationId, 0);
        }
        return Collections.singleton(transformationId);
    }
}

