/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.streaming.api.operators.sort.BytesKeyNormalizationUtil;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class FixedLengthByteKeyComparator<IN>
extends TypeComparator<Tuple2<byte[], StreamRecord<IN>>> {
    static final int TIMESTAMP_BYTE_SIZE = 8;
    private final int keyLength;
    private byte[] keyReference;
    private long timestampReference;

    FixedLengthByteKeyComparator(int keyLength) {
        this.keyLength = keyLength;
    }

    @Override
    public int hash(Tuple2<byte[], StreamRecord<IN>> record) {
        return record.hashCode();
    }

    @Override
    public void setReference(Tuple2<byte[], StreamRecord<IN>> toCompare) {
        this.keyReference = (byte[])toCompare.f0;
        this.timestampReference = ((StreamRecord)toCompare.f1).asRecord().getTimestamp();
    }

    @Override
    public boolean equalToReference(Tuple2<byte[], StreamRecord<IN>> candidate) {
        return Arrays.equals(this.keyReference, (byte[])candidate.f0) && this.timestampReference == ((StreamRecord)candidate.f1).asRecord().getTimestamp();
    }

    @Override
    public int compareToReference(TypeComparator<Tuple2<byte[], StreamRecord<IN>>> referencedComparator) {
        byte[] otherKey = ((FixedLengthByteKeyComparator)referencedComparator).keyReference;
        long otherTimestamp = ((FixedLengthByteKeyComparator)referencedComparator).timestampReference;
        int keyCmp = this.compare(otherKey, this.keyReference);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return Long.compare(otherTimestamp, this.timestampReference);
    }

    @Override
    public int compare(Tuple2<byte[], StreamRecord<IN>> first, Tuple2<byte[], StreamRecord<IN>> second) {
        int keyCmp = this.compare((byte[])first.f0, (byte[])second.f0);
        if (keyCmp != 0) {
            return keyCmp;
        }
        return Long.compare(((StreamRecord)first.f1).asRecord().getTimestamp(), ((StreamRecord)second.f1).asRecord().getTimestamp());
    }

    @Override
    private int compare(byte[] first, byte[] second) {
        for (int i = 0; i < this.keyLength; ++i) {
            int cmp = Byte.compare(first[i], second[i]);
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return 0;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int minCount = this.keyLength;
        while (minCount-- > 0) {
            byte secondValue;
            byte firstValue = firstSource.readByte();
            int cmp = Byte.compare(firstValue, secondValue = secondSource.readByte());
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return Long.compare(firstSource.readLong(), secondSource.readLong());
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.keyLength + 8;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(Tuple2<byte[], StreamRecord<IN>> record, MemorySegment target, int offset, int numBytes) {
        BytesKeyNormalizationUtil.putNormalizedKey(record, this.keyLength, target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return false;
    }

    @Override
    public TypeComparator<Tuple2<byte[], StreamRecord<IN>>> duplicate() {
        return new FixedLengthByteKeyComparator<IN>(this.keyLength);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return new TypeComparator[]{this};
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(Tuple2<byte[], StreamRecord<IN>> record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple2<byte[], StreamRecord<IN>> readWithKeyDenormalization(Tuple2<byte[], StreamRecord<IN>> reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

