/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.util.Preconditions;

public class IntermediateResultPartition {
    private static final int UNKNOWN = -1;
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final IntermediateResultPartitionID partitionId;
    private final EdgeManager edgeManager;
    private int numberOfSubpartitions = -1;
    private boolean hasDataProduced = false;
    private final Set<ConsumedPartitionGroup> releasablePartitionGroups = new HashSet<ConsumedPartitionGroup>();

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber, EdgeManager edgeManager) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionId = new IntermediateResultPartitionID(totalResult.getId(), partitionNumber);
        this.edgeManager = edgeManager;
    }

    public void markPartitionGroupReleasable(ConsumedPartitionGroup partitionGroup) {
        this.releasablePartitionGroups.add(partitionGroup);
    }

    public boolean canBeReleased() {
        if (this.releasablePartitionGroups.size() != this.edgeManager.getNumberOfConsumedPartitionGroupsById(this.partitionId)) {
            return false;
        }
        for (JobVertexID jobVertexId : this.totalResult.getConsumerVertices()) {
            if (this.producer.getExecutionGraphAccessor().getJobVertex(jobVertexId).isInitialized()) continue;
            return false;
        }
        return true;
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionId.getPartitionNumber();
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.getEdgeManager().getConsumerVertexGroupsForPartition(this.partitionId);
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.getEdgeManager().getConsumedPartitionGroupsById(this.partitionId);
    }

    public int getNumberOfSubpartitions() {
        if (this.numberOfSubpartitions == -1) {
            this.numberOfSubpartitions = this.computeNumberOfSubpartitions();
            Preconditions.checkState(this.numberOfSubpartitions > 0, "Number of subpartitions is an unexpected value: " + this.numberOfSubpartitions);
        }
        return this.numberOfSubpartitions;
    }

    private int computeNumberOfSubpartitions() {
        if (!this.getProducer().getExecutionGraphAccessor().isDynamic()) {
            List<ConsumerVertexGroup> consumerVertexGroups = this.getConsumerVertexGroups();
            Preconditions.checkState(!consumerVertexGroups.isEmpty());
            return consumerVertexGroups.get(0).size();
        }
        if (this.totalResult.isBroadcast()) {
            return 1;
        }
        return this.computeNumberOfMaxPossiblePartitionConsumers();
    }

    private int computeNumberOfMaxPossiblePartitionConsumers() {
        DistributionPattern distributionPattern = this.getIntermediateResult().getConsumingDistributionPattern();
        int maxConsumerJobVertexParallelism = this.getIntermediateResult().getConsumersParallelism();
        if (maxConsumerJobVertexParallelism <= 0) {
            maxConsumerJobVertexParallelism = this.getIntermediateResult().getConsumersMaxParallelism();
            Preconditions.checkState(maxConsumerJobVertexParallelism > 0, "Neither the parallelism nor the max parallelism of a job vertex is set");
        }
        if (distributionPattern == DistributionPattern.ALL_TO_ALL) {
            return maxConsumerJobVertexParallelism;
        }
        int numberOfPartitions = this.getIntermediateResult().getNumParallelProducers();
        return (int)Math.ceil((double)maxConsumerJobVertexParallelism / (double)numberOfPartitions);
    }

    public void markDataProduced() {
        this.hasDataProduced = true;
    }

    public boolean isConsumable() {
        return this.hasDataProduced;
    }

    void resetForNewExecution() {
        if (!this.getResultType().canBePipelinedConsumed() && this.hasDataProduced) {
            for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
                consumedPartitionGroup.partitionUnfinished();
            }
        }
        this.releasablePartitionGroups.clear();
        this.hasDataProduced = false;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            this.totalResult.clearCachedInformationForPartitionGroup(consumedPartitionGroup);
        }
    }

    public void addConsumers(ConsumerVertexGroup consumers) {
        this.getEdgeManager().connectPartitionWithConsumerVertexGroup(this.partitionId, consumers);
    }

    private EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    void markFinished() {
        if (this.getResultType().canBePipelinedConsumed()) {
            throw new IllegalStateException("Tried to mark a non-blocking result partition as finished");
        }
        if (this.hasDataProduced) {
            throw new IllegalStateException("Tried to mark a finished result partition as finished.");
        }
        this.hasDataProduced = true;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            consumedPartitionGroup.partitionFinished();
        }
    }
}

