/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.deployment.SubpartitionIndexRange;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.CompressedSerializedValue;
import org.apache.flink.util.Preconditions;

public class InputGateDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -7143441863165366704L;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    private final SubpartitionIndexRange consumedSubpartitionIndexRange;
    private transient ShuffleDescriptor[] inputChannels;
    private TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> serializedInputChannels;

    @VisibleForTesting
    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, ShuffleDescriptor[] inputChannels) throws IOException {
        this(consumedResultId, consumedPartitionType, new SubpartitionIndexRange(consumedSubpartitionIndex, consumedSubpartitionIndex), new TaskDeploymentDescriptor.NonOffloaded<ShuffleDescriptor[]>(CompressedSerializedValue.fromObject(inputChannels)));
    }

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, SubpartitionIndexRange consumedSubpartitionIndexRange, TaskDeploymentDescriptor.MaybeOffloaded<ShuffleDescriptor[]> serializedInputChannels) {
        this.consumedResultId = Preconditions.checkNotNull(consumedResultId);
        this.consumedPartitionType = Preconditions.checkNotNull(consumedPartitionType);
        this.consumedSubpartitionIndexRange = Preconditions.checkNotNull(consumedSubpartitionIndexRange);
        this.serializedInputChannels = Preconditions.checkNotNull(serializedInputChannels);
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    @Nonnegative
    public int getConsumedSubpartitionIndex() {
        Preconditions.checkState(this.consumedSubpartitionIndexRange.getStartIndex() == this.consumedSubpartitionIndexRange.getEndIndex());
        return this.consumedSubpartitionIndexRange.getStartIndex();
    }

    public SubpartitionIndexRange getConsumedSubpartitionIndexRange() {
        return this.consumedSubpartitionIndexRange;
    }

    public void loadBigData(@Nullable PermanentBlobService blobService, JobID jobId) throws IOException, ClassNotFoundException {
        if (this.serializedInputChannels instanceof TaskDeploymentDescriptor.Offloaded) {
            PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)this.serializedInputChannels).serializedValueKey;
            Preconditions.checkNotNull(blobService);
            CompressedSerializedValue serializedValue = CompressedSerializedValue.fromBytes(blobService.readFile(jobId, blobKey));
            this.serializedInputChannels = new TaskDeploymentDescriptor.NonOffloaded<ShuffleDescriptor[]>(serializedValue);
            Preconditions.checkNotNull(this.serializedInputChannels);
        }
    }

    public ShuffleDescriptor[] getShuffleDescriptors() {
        block3: {
            try {
                if (this.inputChannels != null) break block3;
                if (this.serializedInputChannels instanceof TaskDeploymentDescriptor.NonOffloaded) {
                    TaskDeploymentDescriptor.NonOffloaded nonOffloadedSerializedValue = (TaskDeploymentDescriptor.NonOffloaded)this.serializedInputChannels;
                    this.inputChannels = (ShuffleDescriptor[])nonOffloadedSerializedValue.serializedValue.deserializeValue(this.getClass().getClassLoader());
                    break block3;
                }
                throw new IllegalStateException("Trying to work with offloaded serialized shuffle descriptors.");
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Could not deserialize shuffle descriptors.", e);
            }
        }
        return this.inputChannels;
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition index range: %s, input channels: %s]", this.consumedResultId.toString(), this.consumedSubpartitionIndexRange, Arrays.toString(this.getShuffleDescriptors()));
    }
}

