/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.util.CloseableIterator;

@Internal
public interface ChannelStateWriter
extends Closeable {
    public static final int SEQUENCE_NUMBER_RESTORED = -1;
    public static final int SEQUENCE_NUMBER_UNKNOWN = -2;
    public static final ChannelStateWriter NO_OP = new NoOpChannelStateWriter();

    public void start(long var1, CheckpointOptions var3);

    public void addInputData(long var1, InputChannelInfo var3, int var4, CloseableIterator<Buffer> var5);

    public void addOutputData(long var1, ResultSubpartitionInfo var3, int var4, Buffer ... var5) throws IllegalArgumentException;

    public void addOutputDataFuture(long var1, ResultSubpartitionInfo var3, int var4, CompletableFuture<List<Buffer>> var5) throws IllegalArgumentException;

    public void finishInput(long var1);

    public void finishOutput(long var1);

    public void abort(long var1, Throwable var3, boolean var4);

    public ChannelStateWriteResult getAndRemoveWriteResult(long var1) throws IllegalArgumentException;

    public static class NoOpChannelStateWriter
    implements ChannelStateWriter {
        @Override
        public void start(long checkpointId, CheckpointOptions checkpointOptions) {
        }

        @Override
        public void addInputData(long checkpointId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> data) {
        }

        @Override
        public void addOutputData(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        }

        @Override
        public void addOutputDataFuture(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, CompletableFuture<List<Buffer>> data) {
        }

        @Override
        public void finishInput(long checkpointId) {
        }

        @Override
        public void finishOutput(long checkpointId) {
        }

        @Override
        public void abort(long checkpointId, Throwable cause, boolean cleanup) {
        }

        @Override
        public ChannelStateWriteResult getAndRemoveWriteResult(long checkpointId) {
            return new ChannelStateWriteResult(CompletableFuture.completedFuture(Collections.emptyList()), CompletableFuture.completedFuture(Collections.emptyList()));
        }

        @Override
        public void close() {
        }
    }

    public static class ChannelStateWriteResult {
        final CompletableFuture<Collection<InputChannelStateHandle>> inputChannelStateHandles;
        final CompletableFuture<Collection<ResultSubpartitionStateHandle>> resultSubpartitionStateHandles;
        public static final ChannelStateWriteResult EMPTY = new ChannelStateWriteResult(CompletableFuture.completedFuture(Collections.emptyList()), CompletableFuture.completedFuture(Collections.emptyList()));

        ChannelStateWriteResult() {
            this(new CompletableFuture<Collection<InputChannelStateHandle>>(), new CompletableFuture<Collection<ResultSubpartitionStateHandle>>());
        }

        ChannelStateWriteResult(CompletableFuture<Collection<InputChannelStateHandle>> inputChannelStateHandles, CompletableFuture<Collection<ResultSubpartitionStateHandle>> resultSubpartitionStateHandles) {
            this.inputChannelStateHandles = inputChannelStateHandles;
            this.resultSubpartitionStateHandles = resultSubpartitionStateHandles;
        }

        public CompletableFuture<Collection<InputChannelStateHandle>> getInputChannelStateHandles() {
            return this.inputChannelStateHandles;
        }

        public CompletableFuture<Collection<ResultSubpartitionStateHandle>> getResultSubpartitionStateHandles() {
            return this.resultSubpartitionStateHandles;
        }

        public void fail(Throwable e) {
            this.inputChannelStateHandles.completeExceptionally(e);
            this.resultSubpartitionStateHandles.completeExceptionally(e);
        }

        boolean isDone() {
            return this.inputChannelStateHandles.isDone() && this.resultSubpartitionStateHandles.isDone();
        }
    }
}

