/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.connector.file.table.PartitionComputer;
import org.apache.flink.connector.file.table.PartitionTempFileManager;
import org.apache.flink.connector.file.table.PartitionWriter;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class GroupedPartitionWriter<T>
implements PartitionWriter<T> {
    private final PartitionWriter.Context<T> context;
    private final PartitionTempFileManager manager;
    private final PartitionComputer<T> computer;
    private OutputFormat<T> currentFormat;
    private String currentPartition;

    public GroupedPartitionWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer) {
        this.context = context;
        this.manager = manager;
        this.computer = computer;
    }

    @Override
    public void write(T in) throws Exception {
        String partition = PartitionPathUtils.generatePartitionPath(this.computer.generatePartValues(in));
        if (!partition.equals(this.currentPartition)) {
            if (this.currentFormat != null) {
                this.currentFormat.close();
            }
            this.currentFormat = this.context.createNewOutputFormat(this.manager.createPartitionDir(partition));
            this.currentPartition = partition;
        }
        this.currentFormat.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        if (this.currentFormat != null) {
            this.currentFormat.close();
            this.currentFormat = null;
        }
    }
}

