/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.table.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class ConfigurationValidatorUtil {
    public static void validateOptionalBooleanProperty(Properties config, String key, String message) {
        if (config.containsKey(key) && !config.getProperty(key).equals("true") && !config.getProperty(key).equals("false")) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void validateOptionalPositiveIntProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                int value = Integer.parseInt(config.getProperty(key));
                if (value < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void validateOptionalPositiveLongProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                long value = Long.parseLong(config.getProperty(key));
                if (value < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void validateOptionalPositiveDoubleProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                double value = Double.parseDouble(config.getProperty(key));
                if (value < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    public static void validateOptionalDateProperty(Properties config, String timestampKey, String format, String message) {
        if (config.containsKey(timestampKey)) {
            try {
                SimpleDateFormat customDateFormat = new SimpleDateFormat(format);
                customDateFormat.parse(config.getProperty(timestampKey));
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                throw new IllegalArgumentException(message);
            }
            catch (ParseException exception) {
                try {
                    double value = Double.parseDouble(config.getProperty(timestampKey));
                    if (value < 0.0) {
                        throw new IllegalArgumentException(message);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(message);
                }
            }
        }
    }
}

