/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.GenericInequalitySearch;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.GenericSortedView;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.IncludeMinMax;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public class ItemsSketchSortedView<T>
implements GenericSortedView<T> {
    private final T[] quantiles;
    private final long[] cumWeights;
    private final long totalN;
    private final Comparator<? super T> comparator;
    private final Class<T> clazz;
    private final double normRankError;
    private final int numRetItems;

    public ItemsSketchSortedView(T[] quantiles, long[] cumWeights, QuantilesGenericAPI<T> sk) {
        this.comparator = sk.getComparator();
        IncludeMinMax.ItemsPair<? super T> iPair = IncludeMinMax.includeItemsMinMax(quantiles, cumWeights, sk.getMaxItem(), sk.getMinItem(), this.comparator);
        this.quantiles = iPair.quantiles;
        this.cumWeights = iPair.cumWeights;
        this.totalN = sk.getN();
        this.clazz = sk.getClassOfT();
        this.normRankError = sk.getNormalizedRankError(true);
        this.numRetItems = sk.getNumRetained();
    }

    ItemsSketchSortedView(T[] quantiles, long[] cumWeights, long totalN, Comparator<? super T> comparator, T maxItem, T minItem, Class<T> clazz, double normRankError, int numRetItems) {
        this.comparator = comparator;
        IncludeMinMax.ItemsPair<? super T> iPair = IncludeMinMax.includeItemsMinMax(quantiles, cumWeights, maxItem, minItem, comparator);
        this.quantiles = iPair.quantiles;
        this.cumWeights = iPair.cumWeights;
        this.totalN = totalN;
        this.clazz = clazz;
        this.normRankError = normRankError;
        this.numRetItems = numRetItems;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public T getMaxItem() {
        int top = this.quantiles.length - 1;
        return this.quantiles[top];
    }

    @Override
    public T getMinItem() {
        return this.quantiles[0];
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public int getNumRetained() {
        return this.quantiles.length;
    }

    @Override
    public int getMaxPartitions() {
        return (int)Math.min(1.0 / this.normRankError, (double)this.numRetItems / 2.0);
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundariesFromPartSize(long nominalPartitionSize, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        long minPartSizeItems = this.getMinPartitionSizeItems();
        if (nominalPartitionSize < minPartSizeItems) {
            throw new SketchesArgumentException("Unsupported operation for this Sketch Type.  The requested nominal partition size is too small for this sketch.");
        }
        long totalN = this.totalN;
        int numEquallySizedParts = (int)Math.min(totalN / minPartSizeItems, (long)this.getMaxPartitions());
        return this.getPartitionBoundariesFromNumParts(numEquallySizedParts);
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundariesFromNumParts(int numEquallySizedParts, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int maxParts = this.getMaxPartitions();
        if (numEquallySizedParts > maxParts) {
            throw new SketchesArgumentException("Unsupported operation for this Sketch Type.  The requested number of partitions is too large for this sketch.");
        }
        double[] searchNormRanks = QuantilesUtil.evenlySpacedDoubles(0.0, 1.0, numEquallySizedParts + 1);
        int partArrLen = searchNormRanks.length;
        Object[] partQuantiles = (Object[])Array.newInstance(this.clazz, partArrLen);
        long[] partNatRanks = new long[partArrLen];
        double[] partNormRanks = new double[partArrLen];
        for (int i = 0; i < partArrLen; ++i) {
            long cumWt;
            int index = this.getQuantileIndex(searchNormRanks[i], this.cumWeights, searchCrit);
            partQuantiles[i] = this.quantiles[index];
            partNatRanks[i] = cumWt = this.cumWeights[index];
            partNormRanks[i] = (double)cumWt / (double)this.totalN;
        }
        GenericPartitionBoundaries<Object> gpb = new GenericPartitionBoundaries<Object>(this.totalN, partQuantiles, partNatRanks, partNormRanks, this.getMaxItem(), this.getMinItem(), searchCrit);
        return gpb;
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int index = this.getQuantileIndex(rank, this.cumWeights, searchCrit);
        return this.quantiles[index];
    }

    private int getQuantileIndex(double normRank, long[] localCumWeights, QuantileSearchCriteria searchCrit) {
        InequalitySearch crit;
        int len = localCumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(normRank, this.totalN, searchCrit);
        int index = InequalitySearch.find(localCumWeights, 0, len - 1, naturalRank, crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT);
        if (index == -1) {
            return len - 1;
        }
        return index;
    }

    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = ranks.length;
        Object[] quants = (Object[])Array.newInstance(this.clazz, len);
        for (int i = 0; i < len; ++i) {
            quants[i] = this.getQuantile(ranks[i], searchCrit);
        }
        return quants;
    }

    @Override
    public T[] getQuantiles() {
        return (Object[])this.quantiles.clone();
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        GenericInequalitySearch.Inequality crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? GenericInequalitySearch.Inequality.LE : GenericInequalitySearch.Inequality.LT;
        int index = GenericInequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit, this.comparator);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public GenericSortedViewIterator<T> iterator() {
        return new GenericSortedViewIterator<T>(this.quantiles, this.cumWeights);
    }
}

