/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyMemoryTest {
    @Test
    public void wrapAndTryUpdatingSketch() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = (ArrayOfDoublesUpdatableSketch)ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)1.0);
        sketch2.toByteArray();
        boolean thrown = false;
        try {
            sketch2.update(2L, new double[]{1.0});
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        try {
            sketch2.trim();
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void heapifyAndUpdateSketch() {
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch1.update(1L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketch2 = (ArrayOfDoublesUpdatableSketch)ArrayOfDoublesSketches.heapifySketch((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        sketch2.update(2L, new double[]{1.0});
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0);
    }

    @Test
    public void wrapAndTryUpdatingUnionEstimationMode() {
        int numUniques = 10000;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union1.union((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesSketches.wrapUnion((Memory)Memory.wrap((byte[])union1.toByteArray()));
        ArrayOfDoublesCompactSketch resultSketch = union2.getResult();
        Assert.assertTrue((boolean)resultSketch.isEstimationMode());
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)10000.0, (double)400.0);
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        boolean thrown = false;
        try {
            union2.union((ArrayOfDoublesSketch)sketch2);
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void heapifyAndUpdateUnion() {
        int numUniques = 10000;
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketch1 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesUnion union1 = new ArrayOfDoublesSetOperationBuilder().buildUnion();
        union1.union((ArrayOfDoublesSketch)sketch1);
        ArrayOfDoublesUnion union2 = ArrayOfDoublesSketches.heapifyUnion((Memory)Memory.wrap((byte[])union1.toByteArray()));
        ArrayOfDoublesCompactSketch resultSketch = union2.getResult();
        Assert.assertTrue((boolean)resultSketch.isEstimationMode());
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)10000.0, (double)400.0);
        ArrayOfDoublesUpdatableSketch sketch2 = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sketch2.update((long)key++, new double[]{1.0});
        }
        union2.union((ArrayOfDoublesSketch)sketch2);
    }
}

