/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.HashSet;
import java.util.function.BiConsumer;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.DeferredLintHandler;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeAnnotations;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Check;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.MemberEnter;
import org.openjdk.tools.javac.comp.Todo;
import org.openjdk.tools.javac.comp.TypeEnvs;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Dependencies;
import org.openjdk.tools.javac.util.FatalError;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;

public class TypeEnter
implements Symbol.Completer {
    protected static final Context.Key<TypeEnter> typeEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Names names;
    private final Enter enter;
    private final MemberEnter memberEnter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final Todo todo;
    private final Annotate annotate;
    private final TypeAnnotations typeAnnotations;
    private final Types types;
    private final JCDiagnostic.Factory diags;
    private final DeferredLintHandler deferredLintHandler;
    private final Lint lint;
    private final TypeEnvs typeEnvs;
    private final Dependencies dependencies;
    boolean allowTypeAnnos;
    boolean allowDeprecationOnImport;
    boolean completionEnabled = true;
    private final ImportsPhase completeClass = new ImportsPhase();
    private Phase topLevelPhase;

    public static TypeEnter instance(Context context) {
        TypeEnter typeEnter = context.get(typeEnterKey);
        if (typeEnter == null) {
            typeEnter = new TypeEnter(context);
        }
        return typeEnter;
    }

    protected TypeEnter(Context context) {
        context.put(typeEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.lint = Lint.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dependencies = Dependencies.instance(context);
        Source source = Source.instance(context);
        this.allowTypeAnnos = source.allowTypeAnnotations();
        this.allowDeprecationOnImport = source.allowDeprecationOnImport();
    }

    protected void ensureImportsChecked(List<JCTree.JCCompilationUnit> list) {
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            if (jCCompilationUnit.starImportScope.isFilled()) continue;
            Env<AttrContext> env = this.enter.topLevelEnv(jCCompilationUnit);
            this.finishImports(jCCompilationUnit, () -> this.completeClass.resolveImports(jCCompilationUnit, env));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            Assert.check((symbol.flags() & 0x1000000L) == 0L);
            symbol.completer = this;
            return;
        }
        try {
            List<Env<AttrContext>> list;
            this.annotate.blockAnnotations();
            symbol.flags_field |= 0x10000000L;
            this.dependencies.push((Symbol.ClassSymbol)symbol, Dependencies.CompletionCause.MEMBER_ENTER);
            try {
                list = this.completeClass.completeEnvs(List.of(this.typeEnvs.get((Symbol.ClassSymbol)symbol)));
            }
            finally {
                this.dependencies.pop();
            }
            if (!list.isEmpty()) {
                HashSet<JCTree.JCCompilationUnit> hashSet = new HashSet<JCTree.JCCompilationUnit>();
                for (Env<AttrContext> env : list) {
                    if (!env.toplevel.defs.contains(env.enclClass) || !hashSet.add(env.toplevel)) continue;
                    this.finishImports(env.toplevel, () -> {});
                }
            }
        }
        finally {
            this.annotate.unblockAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishImports(JCTree.JCCompilationUnit jCCompilationUnit, Runnable runnable) {
        JavaFileObject javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
        try {
            runnable.run();
            this.chk.checkImportsUnique(jCCompilationUnit);
            this.chk.checkImportsResolvable(jCCompilationUnit);
            this.chk.checkImportedPackagesObservable(jCCompilationUnit);
            jCCompilationUnit.namedImportScope.finalizeScope();
            jCCompilationUnit.starImportScope.finalizeScope();
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    JCTree DefaultConstructor(TreeMaker treeMaker, Symbol.ClassSymbol classSymbol, Symbol.MethodSymbol methodSymbol, List<Type> list, List<Type> list2, List<Type> list3, long l, boolean bl) {
        l = (classSymbol.flags() & 0x4000L) != 0L && this.types.supertype((Type)classSymbol.type).tsym == this.syms.enumSym ? l & 0xFFFFFFFFFFFFFFF8L | 2L | 0x1000000000L : (l |= classSymbol.flags() & 7L | 0x1000000000L);
        if (classSymbol.name.isEmpty()) {
            l |= 0x20000000L;
        }
        Type.MethodType methodType = new Type.MethodType(list2, null, list3, classSymbol);
        Type type = list.nonEmpty() ? new Type.ForAll(list, (Type)methodType) : methodType;
        Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(l, this.names.init, type, classSymbol);
        methodSymbol2.params = this.createDefaultConstructorParams(treeMaker, methodSymbol, methodSymbol2, list2, bl);
        List<JCTree.JCVariableDecl> list4 = treeMaker.Params(list2, methodSymbol2);
        List<JCTree.JCStatement> list5 = List.nil();
        if (classSymbol.type != this.syms.objectType) {
            list5 = list5.prepend(this.SuperCall(treeMaker, list, list4, bl));
        }
        JCTree.JCMethodDecl jCMethodDecl = treeMaker.MethodDef(methodSymbol2, treeMaker.Block(0L, list5));
        return jCMethodDecl;
    }

    private List<Symbol.VarSymbol> createDefaultConstructorParams(TreeMaker treeMaker, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, List<Type> list, boolean bl) {
        List list2;
        List<Symbol.VarSymbol> list3 = null;
        List<Type> list4 = list;
        if (bl) {
            list3 = List.nil();
            list2 = new Symbol.VarSymbol(0x200000000L, treeMaker.paramName(0), (Type)list.head, methodSymbol2);
            list3 = list3.append((Symbol.VarSymbol)((Object)list2));
            list4 = list4.tail;
        }
        if (methodSymbol != null && methodSymbol.params != null && methodSymbol.params.nonEmpty() && list4.nonEmpty()) {
            list3 = list3 == null ? List.nil() : list3;
            list2 = methodSymbol.params;
            while (list2.nonEmpty() && list4.nonEmpty()) {
                Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(((Symbol.VarSymbol)list2.head).flags() | 0x200000000L, ((Symbol.VarSymbol)list2.head).name, (Type)list4.head, methodSymbol2);
                list3 = list3.append(varSymbol);
                list2 = list2.tail;
                list4 = list4.tail;
            }
        }
        return list3;
    }

    JCTree.JCExpressionStatement SuperCall(TreeMaker treeMaker, List<Type> list, List<JCTree.JCVariableDecl> list2, boolean bl) {
        JCTree.JCExpression jCExpression;
        if (bl) {
            jCExpression = treeMaker.Select(treeMaker.Ident((JCTree.JCVariableDecl)list2.head), this.names._super);
            list2 = list2.tail;
        } else {
            jCExpression = treeMaker.Ident(this.names._super);
        }
        List<JCTree.JCExpression> list3 = list.nonEmpty() ? treeMaker.Types(list) : null;
        return treeMaker.Exec(treeMaker.Apply(list3, jCExpression, treeMaker.Idents(list2)));
    }

    public void markDeprecated(Symbol symbol, List<JCTree.JCAnnotation> list, Env<AttrContext> env) {
        this.attr.attribAnnotationTypes(list, env);
        this.handleDeprecatedAnnotations(list, symbol);
    }

    private void handleDeprecatedAnnotations(List<JCTree.JCAnnotation> list, Symbol symbol) {
        List<JCTree.JCAnnotation> list2 = list;
        while (!list2.isEmpty()) {
            JCTree.JCAnnotation jCAnnotation = (JCTree.JCAnnotation)list2.head;
            if (jCAnnotation.annotationType.type == this.syms.deprecatedType) {
                symbol.flags_field |= 0x40000000020000L;
                jCAnnotation.args.stream().filter(jCExpression -> jCExpression.hasTag(JCTree.Tag.ASSIGN)).map(jCExpression -> (JCTree.JCAssign)jCExpression).filter(jCAssign -> TreeInfo.name(jCAssign.lhs) == this.names.forRemoval).findFirst().ifPresent(jCAssign -> {
                    JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.rhs);
                    if (jCExpression.hasTag(JCTree.Tag.LITERAL) && Boolean.TRUE.equals(((JCTree.JCLiteral)jCExpression).getValue())) {
                        symbol.flags_field |= 0x80000000000000L;
                    }
                });
            }
            list2 = list2.tail;
        }
    }

    private final class MembersPhase
    extends Phase {
        private boolean completing;
        private List<Env<AttrContext>> todo;

        public MembersPhase() {
            super(Dependencies.CompletionCause.MEMBERS_PHASE, null);
            this.todo = List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            this.todo = this.todo.prependList(list);
            if (this.completing) {
                return;
            }
            boolean bl = this.completing;
            this.completing = true;
            try {
                while (this.todo.nonEmpty()) {
                    Env env = (Env)this.todo.head;
                    this.todo = this.todo.tail;
                    super.doCompleteEnvs(List.of(env));
                }
            }
            finally {
                this.completing = bl;
            }
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            List<Type> list;
            List<Type> list2;
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            if ((classSymbol.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(jCClassDecl.defs)) {
                AnnoConstruct annoConstruct;
                list2 = List.nil();
                list = List.nil();
                List<Type> list3 = List.nil();
                long l = 0L;
                boolean bl = false;
                boolean bl2 = true;
                JCTree.JCNewClass jCNewClass = null;
                if (classSymbol.name.isEmpty()) {
                    jCNewClass = (JCTree.JCNewClass)env.next.tree;
                    if (jCNewClass.constructor != null) {
                        bl2 = jCNewClass.constructor.kind != Kinds.Kind.ERR;
                        annoConstruct = TypeEnter.this.types.memberType(classSymbol.type, jCNewClass.constructor);
                        list2 = ((Type)annoConstruct).getParameterTypes();
                        list = ((Type)annoConstruct).getTypeArguments();
                        l = jCNewClass.constructor.flags() & 0x400000000L;
                        if (jCNewClass.encl != null) {
                            list2 = list2.prepend(jCNewClass.encl.type);
                            bl = true;
                        }
                        list3 = ((Type)annoConstruct).getThrownTypes();
                    }
                }
                if (bl2) {
                    annoConstruct = jCNewClass != null ? (Symbol.MethodSymbol)jCNewClass.constructor : null;
                    JCTree jCTree = TypeEnter.this.DefaultConstructor(TypeEnter.this.make.at(jCClassDecl.pos), classSymbol, (Symbol.MethodSymbol)annoConstruct, list, list2, list3, l, bl);
                    jCClassDecl.defs = jCClassDecl.defs.prepend(jCTree);
                }
            }
            list2 = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._this, classSymbol.type, classSymbol);
            ((Symbol.VarSymbol)((Object)list2)).pos = 0;
            ((AttrContext)env.info).scope.enter((Symbol)((Object)list2));
            if ((classSymbol.flags_field & 0x200L) == 0L && classType.supertype_field.hasTag(TypeTag.CLASS)) {
                list = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._super, classType.supertype_field, classSymbol);
                ((Symbol.VarSymbol)((Object)list)).pos = 0;
                ((AttrContext)env.info).scope.enter((Symbol)((Object)list));
            }
            this.finishClass(jCClassDecl, env);
            if (TypeEnter.this.allowTypeAnnos) {
                TypeEnter.this.typeAnnotations.organizeTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
                TypeEnter.this.typeAnnotations.validateTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
            }
        }

        void finishClass(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            if ((jCClassDecl.mods.flags & 0x4000L) != 0L && !jCClassDecl.sym.type.hasTag(TypeTag.ERROR) && (((TypeEnter)TypeEnter.this).types.supertype((Type)jCClassDecl.sym.type).tsym.flags() & 0x4000L) == 0L) {
                this.addEnumMembers(jCClassDecl, env);
            }
            TypeEnter.this.memberEnter.memberEnter(jCClassDecl.defs, env);
            if (jCClassDecl.sym.isAnnotationType()) {
                Assert.check(jCClassDecl.sym.isCompleted());
                jCClassDecl.sym.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(jCClassDecl.sym, TypeEnter.this.annotate.annotationTypeSourceCompleter()));
            }
        }

        private void addEnumMembers(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            JCTree.JCExpression jCExpression = TypeEnter.this.make.Type(new Type.ArrayType(jCClassDecl.sym.type, ((TypeEnter)TypeEnter.this).syms.arrayClass));
            JCTree.JCMethodDecl jCMethodDecl = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.values, jCExpression, List.nil(), List.nil(), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(jCMethodDecl, env);
            JCTree.JCMethodDecl jCMethodDecl2 = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.valueOf, TypeEnter.this.make.Type(jCClassDecl.sym.type), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200008000L), TypeEnter.this.names.fromString("name"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), null)), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(jCMethodDecl2, env);
        }
    }

    private final class HeaderPhase
    extends AbstractHeaderPhase {
        public HeaderPhase() {
            super(Dependencies.CompletionCause.HEADER_PHASE, new MembersPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            Env<AttrContext> env2 = this.baseEnv(jCClassDecl, env);
            if (jCClassDecl.extending != null) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(jCClassDecl.extending, env2, classSymbol, jCClassDecl.pos());
            }
            for (JCTree.JCExpression iterator : jCClassDecl.implementing) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(iterator, env2, classSymbol, jCClassDecl.pos());
            }
            TypeEnter.this.annotate.flush();
            this.attribSuperTypes(env, env2);
            HashSet hashSet = new HashSet();
            for (JCTree.JCExpression jCExpression : jCClassDecl.implementing) {
                Type type = jCExpression.type;
                if (!type.hasTag(TypeTag.CLASS)) continue;
                TypeEnter.this.chk.checkNotRepeated(jCExpression.pos(), TypeEnter.this.types.erasure(type), hashSet);
            }
            TypeEnter.this.annotate.annotateLater(jCClassDecl.mods.annotations, env2, classSymbol, jCClassDecl.pos());
            TypeEnter.this.attr.attribTypeVariables(jCClassDecl.typarams, env2);
            for (JCTree.JCTypeParameter jCTypeParameter : jCClassDecl.typarams) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(jCTypeParameter, env2, classSymbol, jCClassDecl.pos());
            }
            if (classSymbol.owner.kind == Kinds.Kind.PCK && classSymbol.owner != env.toplevel.modle.unnamedPackage && TypeEnter.this.syms.packageExists(env.toplevel.modle, classSymbol.fullname)) {
                TypeEnter.this.log.error(jCClassDecl.pos, "clash.with.pkg.of.same.name", Kinds.kindName(classSymbol), classSymbol);
            }
            if (classSymbol.owner.kind == Kinds.Kind.PCK && (classSymbol.flags_field & 1L) == 0L && !env.toplevel.sourcefile.isNameCompatible(classSymbol.name.toString(), JavaFileObject.Kind.SOURCE)) {
                classSymbol.flags_field |= 0x100000000000L;
            }
        }
    }

    private final class HierarchyPhase
    extends AbstractHeaderPhase
    implements Symbol.Completer {
        public HierarchyPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new HeaderPhase());
        }

        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            for (Env<AttrContext> env : list) {
                env.enclClass.sym.completer = this;
            }
            for (Env<AttrContext> env : list) {
                env.enclClass.sym.complete();
            }
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            Env<AttrContext> env2 = this.baseEnv(jCClassDecl, env);
            this.attribSuperTypes(env, env2);
            if (classSymbol.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                if (jCClassDecl.extending != null) {
                    TypeEnter.this.chk.checkNonCyclic(jCClassDecl.extending.pos(), classType.supertype_field);
                    classType.supertype_field = Type.noType;
                } else if (jCClassDecl.implementing.nonEmpty()) {
                    TypeEnter.this.chk.checkNonCyclic(((JCTree.JCExpression)jCClassDecl.implementing.head).pos(), (Type)classType.interfaces_field.head);
                    classType.interfaces_field = List.nil();
                }
            }
            TypeEnter.this.markDeprecated(classSymbol, jCClassDecl.mods.annotations, env2);
            TypeEnter.this.chk.checkNonCyclicDecl(jCClassDecl);
        }

        @Override
        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression jCExpression) {
            switch (jCExpression.getTag()) {
                case TYPEAPPLY: {
                    return ((JCTree.JCTypeApply)jCExpression).clazz;
                }
            }
            return jCExpression;
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            Assert.check(TypeEnter.this.topLevelPhase instanceof ImportsPhase || TypeEnter.this.topLevelPhase == this);
            if (TypeEnter.this.topLevelPhase != this) {
                symbol.completer = this;
                return;
            }
            Env<AttrContext> env = TypeEnter.this.typeEnvs.get((Symbol.ClassSymbol)symbol);
            super.doCompleteEnvs(List.of(env));
        }
    }

    private abstract class AbstractHeaderPhase
    extends Phase {
        public AbstractHeaderPhase(Dependencies.CompletionCause completionCause, Phase phase) {
            super(completionCause, phase);
        }

        protected Env<AttrContext> baseEnv(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            Iterable iterable;
            Scope.WriteableScope writeableScope = Scope.WriteableScope.create(jCClassDecl.sym);
            for (Symbol object2 : ((AttrContext)env.outer.info).scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (!object2.isLocal()) continue;
                writeableScope.enter(object2);
            }
            if (jCClassDecl.typarams != null) {
                iterable = jCClassDecl.typarams;
                while (((List)iterable).nonEmpty()) {
                    writeableScope.enter(((JCTree.JCTypeParameter)((List)iterable).head).type.tsym);
                    iterable = ((List)iterable).tail;
                }
            }
            iterable = env.outer;
            Env<AttrContext> env2 = iterable.dup(jCClassDecl, ((AttrContext)iterable.info).dup(writeableScope));
            env2.baseClause = true;
            env2.outer = iterable;
            ((AttrContext)env2.info).isSelfCall = false;
            return env2;
        }

        protected JCTree.JCExpression enumBase(int n, Symbol.ClassSymbol classSymbol) {
            JCTree.JCTypeApply jCTypeApply = TypeEnter.this.make.at(n).TypeApply(TypeEnter.this.make.QualIdent(((TypeEnter)TypeEnter.this).syms.enumSym), List.of(TypeEnter.this.make.Type(classSymbol.type)));
            return jCTypeApply;
        }

        protected Type modelMissingTypes(final Env<AttrContext> env, Type type, final JCTree.JCExpression jCExpression, final boolean bl) {
            if (!type.hasTag(TypeTag.ERROR)) {
                return type;
            }
            return new Type.ErrorType(type.getOriginalType(), type.tsym){
                private Type modelType;

                @Override
                public Type getModelType() {
                    if (this.modelType == null) {
                        this.modelType = new Synthesizer(env.toplevel.modle, this.getOriginalType(), bl).visit(jCExpression);
                    }
                    return this.modelType;
                }
            };
        }

        protected void attribSuperTypes(Env<AttrContext> env, Env<AttrContext> env2) {
            Type type;
            JCTree.JCExpression jCExpression;
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            if (jCClassDecl.extending != null) {
                jCExpression = this.clearTypeParams(jCClassDecl.extending);
                type = TypeEnter.this.attr.attribBase(jCExpression, env2, true, false, true);
            } else {
                jCExpression = null;
                type = (jCClassDecl.mods.flags & 0x4000L) != 0L ? TypeEnter.this.attr.attribBase(this.enumBase(jCClassDecl.pos, classSymbol), env2, true, false, false) : (classSymbol.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object ? Type.noType : ((TypeEnter)TypeEnter.this).syms.objectType);
            }
            classType.supertype_field = this.modelMissingTypes(env2, type, jCExpression, false);
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            ListBuffer<Type> listBuffer2 = null;
            List<JCTree.JCExpression> list = jCClassDecl.implementing;
            for (JCTree.JCExpression jCExpression2 : list) {
                jCExpression2 = this.clearTypeParams(jCExpression2);
                Type type2 = TypeEnter.this.attr.attribBase(jCExpression2, env2, false, true, true);
                if (type2.hasTag(TypeTag.CLASS)) {
                    listBuffer.append(type2);
                    if (listBuffer2 == null) continue;
                    listBuffer2.append(type2);
                    continue;
                }
                if (listBuffer2 == null) {
                    listBuffer2 = new ListBuffer<Type>().appendList(listBuffer);
                }
                listBuffer2.append(this.modelMissingTypes(env2, type2, jCExpression2, true));
            }
            if ((classSymbol.flags_field & 0x2000L) != 0L) {
                classType.interfaces_field = List.of(((TypeEnter)TypeEnter.this).syms.annotationType);
                classType.all_interfaces_field = classType.interfaces_field;
            } else {
                classType.interfaces_field = listBuffer.toList();
                classType.all_interfaces_field = listBuffer2 == null ? classType.interfaces_field : listBuffer2.toList();
            }
        }

        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression jCExpression) {
            return jCExpression;
        }

        private class Synthesizer
        extends JCTree.Visitor {
            Symbol.ModuleSymbol msym;
            Type originalType;
            boolean interfaceExpected;
            List<Symbol.ClassSymbol> synthesizedSymbols = List.nil();
            Type result;

            Synthesizer(Symbol.ModuleSymbol moduleSymbol, Type type, boolean bl) {
                this.msym = moduleSymbol;
                this.originalType = type;
                this.interfaceExpected = bl;
            }

            Type visit(JCTree jCTree) {
                jCTree.accept(this);
                return this.result;
            }

            List<Type> visit(List<? extends JCTree> list) {
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                for (JCTree jCTree : list) {
                    listBuffer.append(this.visit(jCTree));
                }
                return listBuffer.toList();
            }

            @Override
            public void visitTree(JCTree jCTree) {
                this.result = ((TypeEnter)TypeEnter.this).syms.errType;
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                this.result = !jCIdent.type.hasTag(TypeTag.ERROR) ? jCIdent.type : this.synthesizeClass((Name)jCIdent.name, (Symbol)this.msym.unnamedPackage).type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                if (!jCFieldAccess.type.hasTag(TypeTag.ERROR)) {
                    this.result = jCFieldAccess.type;
                } else {
                    Type type;
                    boolean bl = this.interfaceExpected;
                    try {
                        this.interfaceExpected = false;
                        type = this.visit(jCFieldAccess.selected);
                    }
                    finally {
                        this.interfaceExpected = bl;
                    }
                    Symbol.ClassSymbol classSymbol = this.synthesizeClass(jCFieldAccess.name, type.tsym);
                    this.result = classSymbol.type;
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
                if (!jCTypeApply.type.hasTag(TypeTag.ERROR)) {
                    this.result = jCTypeApply.type;
                } else {
                    Type.ClassType classType = (Type.ClassType)this.visit(jCTypeApply.clazz);
                    if (this.synthesizedSymbols.contains(classType.tsym)) {
                        this.synthesizeTyparams((Symbol.ClassSymbol)classType.tsym, jCTypeApply.arguments.size());
                    }
                    final List<Type> list = this.visit(jCTypeApply.arguments);
                    this.result = new Type.ErrorType(jCTypeApply.type, classType.tsym){

                        @Override
                        public List<Type> getTypeArguments() {
                            return list;
                        }
                    };
                }
            }

            Symbol.ClassSymbol synthesizeClass(Name name, Symbol symbol) {
                int n = this.interfaceExpected ? 512 : 0;
                Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(n, name, symbol);
                classSymbol.members_field = new Scope.ErrorScope(classSymbol);
                classSymbol.type = new Type.ErrorType(this.originalType, (Symbol.TypeSymbol)classSymbol){

                    @Override
                    public List<Type> getTypeArguments() {
                        return this.typarams_field;
                    }
                };
                this.synthesizedSymbols = this.synthesizedSymbols.prepend(classSymbol);
                return classSymbol;
            }

            void synthesizeTyparams(Symbol.ClassSymbol classSymbol, int n) {
                Type.ClassType classType = (Type.ClassType)classSymbol.type;
                Assert.check(classType.typarams_field.isEmpty());
                if (n == 1) {
                    Type.TypeVar typeVar = new Type.TypeVar(TypeEnter.this.names.fromString("T"), classSymbol, ((TypeEnter)TypeEnter.this).syms.botType);
                    classType.typarams_field = classType.typarams_field.prepend(typeVar);
                } else {
                    for (int i = n; i > 0; --i) {
                        Type.TypeVar typeVar = new Type.TypeVar(TypeEnter.this.names.fromString("T" + i), classSymbol, ((TypeEnter)TypeEnter.this).syms.botType);
                        classType.typarams_field = classType.typarams_field.prepend(typeVar);
                    }
                }
            }
        }
    }

    private final class ImportsPhase
    extends Phase {
        Env<AttrContext> env;
        Scope.ImportFilter staticImportFilter;
        Scope.ImportFilter typeImportFilter;
        BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public ImportsPhase() {
            super(Dependencies.CompletionCause.IMPORTS_PHASE, new HierarchyPhase());
            this.cfHandler = (jCImport, completionFailure) -> TypeEnter.this.chk.completionError(jCImport.pos(), (Symbol.CompletionFailure)completionFailure);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            if (classSymbol.owner.kind == Kinds.Kind.PCK) {
                this.resolveImports(env.toplevel, env.enclosing(JCTree.Tag.TOPLEVEL));
                TypeEnter.this.todo.append(env);
            }
            if (classSymbol.owner.kind == Kinds.Kind.TYP) {
                classSymbol.owner.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveImports(JCTree.JCCompilationUnit jCCompilationUnit, Env<AttrContext> env) {
            if (jCCompilationUnit.starImportScope.isFilled()) {
                return;
            }
            Scope.ImportFilter importFilter = this.staticImportFilter;
            Scope.ImportFilter importFilter2 = this.typeImportFilter;
            JCDiagnostic.DiagnosticPosition diagnosticPosition = TypeEnter.this.deferredLintHandler.immediate();
            Lint lint = TypeEnter.this.chk.setLint(TypeEnter.this.lint);
            Env<AttrContext> env2 = this.env;
            try {
                this.env = env;
                Symbol.PackageSymbol packageSymbol = env.toplevel.packge;
                this.staticImportFilter = (scope, symbol) -> symbol.isStatic() && TypeEnter.this.chk.importAccessible(symbol, packageSymbol) && symbol.isMemberOf((Symbol.TypeSymbol)scope.owner, TypeEnter.this.types);
                this.typeImportFilter = (scope, symbol) -> symbol.kind == Kinds.Kind.TYP && TypeEnter.this.chk.importAccessible(symbol, packageSymbol);
                Symbol.PackageSymbol packageSymbol2 = TypeEnter.this.syms.enterPackage(((TypeEnter)TypeEnter.this).syms.java_base, ((TypeEnter)TypeEnter.this).names.java_lang);
                if (packageSymbol2.members().isEmpty() && !packageSymbol2.exists()) {
                    throw new FatalError(TypeEnter.this.diags.fragment("fatal.err.no.java.lang", new Object[0]));
                }
                this.importAll(TypeEnter.this.make.at(jCCompilationUnit.pos()).Import(TypeEnter.this.make.QualIdent(packageSymbol2), false), packageSymbol2, env);
                JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
                if (jCCompilationUnit.getPackage() != null && jCModuleDecl == null) {
                    this.checkClassPackageClash(jCCompilationUnit.getPackage());
                }
                for (JCTree.JCImport jCImport : jCCompilationUnit.getImports()) {
                    this.doImport(jCImport);
                }
                if (jCModuleDecl != null) {
                    TypeEnter.this.markDeprecated(jCModuleDecl.sym, jCModuleDecl.mods.annotations, env);
                    TypeEnter.this.annotate.annotateLater(jCModuleDecl.mods.annotations, env, env.toplevel.modle, null);
                }
            }
            finally {
                this.env = env2;
                TypeEnter.this.chk.setLint(lint);
                TypeEnter.this.deferredLintHandler.setPos(diagnosticPosition);
                this.staticImportFilter = importFilter;
                this.typeImportFilter = importFilter2;
            }
        }

        private void checkClassPackageClash(JCTree.JCPackageDecl jCPackageDecl) {
            if (jCPackageDecl.pid != null) {
                Symbol symbol = this.env.toplevel.packge;
                while (symbol.owner != ((TypeEnter)TypeEnter.this).syms.rootPackage) {
                    symbol.owner.complete();
                    Symbol.PackageSymbol packageSymbol = TypeEnter.this.syms.lookupPackage(this.env.toplevel.modle, symbol.owner.getQualifiedName());
                    if (TypeEnter.this.syms.getClass(packageSymbol.modle, ((Symbol)symbol).getQualifiedName()) != null) {
                        TypeEnter.this.log.error(jCPackageDecl.pos, "pkg.clashes.with.class.of.same.name", symbol);
                    }
                    symbol = symbol.owner;
                }
            }
            TypeEnter.this.annotate.annotateLater(jCPackageDecl.annotations, this.env, this.env.toplevel.packge, null);
        }

        private void doImport(JCTree.JCImport jCImport) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCImport.qualid;
            Name name = TreeInfo.name(jCFieldAccess);
            Env<AttrContext> env = this.env.dup(jCImport);
            Symbol.TypeSymbol typeSymbol = ((TypeEnter)TypeEnter.this).attr.attribImportQualifier((JCTree.JCImport)jCImport, env).tsym;
            if (name == ((TypeEnter)TypeEnter.this).names.asterisk) {
                TypeEnter.this.chk.checkCanonical(jCFieldAccess.selected);
                if (jCImport.staticImport) {
                    this.importStaticAll(jCImport, typeSymbol, this.env);
                } else {
                    this.importAll(jCImport, typeSymbol, this.env);
                }
            } else if (jCImport.staticImport) {
                this.importNamedStatic(jCImport, typeSymbol, name, env);
                TypeEnter.this.chk.checkCanonical(jCFieldAccess.selected);
            } else {
                Type type = this.attribImportType(jCFieldAccess, env);
                Type type2 = type.getOriginalType();
                Symbol.TypeSymbol typeSymbol2 = type2.hasTag(TypeTag.CLASS) ? type2.tsym : type.tsym;
                TypeEnter.this.chk.checkCanonical(jCFieldAccess);
                this.importNamed(jCImport.pos(), typeSymbol2, this.env, jCImport);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type attribImportType(JCTree jCTree, Env<AttrContext> env) {
            Assert.check(TypeEnter.this.completionEnabled);
            Lint lint = TypeEnter.this.chk.setLint(TypeEnter.this.allowDeprecationOnImport ? TypeEnter.this.lint : TypeEnter.this.lint.suppress(Lint.LintCategory.DEPRECATION, Lint.LintCategory.REMOVAL));
            try {
                TypeEnter.this.completionEnabled = false;
                Type type = TypeEnter.this.attr.attribType(jCTree, env);
                return type;
            }
            finally {
                TypeEnter.this.completionEnabled = true;
                TypeEnter.this.chk.setLint(lint);
            }
        }

        private void importAll(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Env<AttrContext> env) {
            env.toplevel.starImportScope.importAll(TypeEnter.this.types, typeSymbol.members(), this.typeImportFilter, jCImport, this.cfHandler);
        }

        private void importStaticAll(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Env<AttrContext> env) {
            Scope.StarImportScope starImportScope = env.toplevel.starImportScope;
            Symbol.TypeSymbol typeSymbol2 = typeSymbol;
            starImportScope.importAll(TypeEnter.this.types, typeSymbol2.members(), this.staticImportFilter, jCImport, this.cfHandler);
        }

        private void importNamedStatic(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Name name, Env<AttrContext> env) {
            if (typeSymbol.kind != Kinds.Kind.TYP) {
                TypeEnter.this.log.error(JCDiagnostic.DiagnosticFlag.RECOVERABLE, jCImport.pos(), "static.imp.only.classes.and.interfaces", new Object[0]);
                return;
            }
            Scope.NamedImportScope namedImportScope = env.toplevel.namedImportScope;
            Scope.WriteableScope writeableScope = typeSymbol.members();
            jCImport.importScope = namedImportScope.importByName(TypeEnter.this.types, writeableScope, name, this.staticImportFilter, jCImport, this.cfHandler);
        }

        private void importNamed(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Env<AttrContext> env, JCTree.JCImport jCImport) {
            if (symbol.kind == Kinds.Kind.TYP) {
                jCImport.importScope = env.toplevel.namedImportScope.importType(symbol.owner.members(), symbol.owner.members(), symbol);
            }
        }
    }

    abstract class Phase {
        private final ListBuffer<Env<AttrContext>> queue = new ListBuffer();
        private final Phase next;
        private final Dependencies.CompletionCause phaseName;

        Phase(Dependencies.CompletionCause completionCause, Phase phase) {
            this.phaseName = completionCause;
            this.next = phase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final List<Env<AttrContext>> completeEnvs(List<Env<AttrContext>> list) {
            boolean bl = this.queue.isEmpty();
            Phase phase = TypeEnter.this.topLevelPhase;
            try {
                TypeEnter.this.topLevelPhase = this;
                this.doCompleteEnvs(list);
            }
            finally {
                TypeEnter.this.topLevelPhase = phase;
            }
            if (bl) {
                List<Env<AttrContext>> list2 = this.queue.toList();
                this.queue.clear();
                return this.next != null ? this.next.completeEnvs(list2) : list2;
            }
            return List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            for (Env<AttrContext> env : list) {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
                this.queue.add(env);
                JavaFileObject javaFileObject = TypeEnter.this.log.useSource(env.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition diagnosticPosition = TypeEnter.this.deferredLintHandler.setPos(jCClassDecl.pos());
                try {
                    TypeEnter.this.dependencies.push(env.enclClass.sym, this.phaseName);
                    this.runPhase(env);
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    TypeEnter.this.chk.completionError(jCClassDecl.pos(), completionFailure);
                }
                finally {
                    TypeEnter.this.dependencies.pop();
                    TypeEnter.this.deferredLintHandler.setPos(diagnosticPosition);
                    TypeEnter.this.log.useSource(javaFileObject);
                }
            }
        }

        protected abstract void runPhase(Env<AttrContext> var1);
    }
}

