/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse.ui;

import org.apache.axis2.tool.codegen.eclipse.CodeGenWizard;
import org.apache.axis2.tool.codegen.eclipse.plugin.CodegenWizardPlugin;
import org.apache.axis2.tool.codegen.eclipse.util.SettingsConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractWizardPage
extends WizardPage
implements SettingsConstants {
    protected IDialogSettings settings;
    protected boolean restoredFromPreviousSettings = false;

    public AbstractWizardPage(String pageName) {
        super(pageName + ".name");
        this.init(pageName);
    }

    protected void init(String pageName) {
        this.setTitle(CodegenWizardPlugin.getResourceString(pageName + ".title"));
        this.setDescription(CodegenWizardPlugin.getResourceString(pageName + ".desc"));
        this.setImageDescriptor(CodegenWizardPlugin.getWizardImageDescriptor());
        IDialogSettings rootSettings = CodegenWizardPlugin.getDefault().getDialogSettings();
        IDialogSettings section = rootSettings.getSection(this.getClass().getName());
        if (section == null) {
            this.settings = rootSettings.addNewSection(this.getClass().getName());
            this.restoredFromPreviousSettings = false;
            this.initializeDefaultSettings();
        } else {
            this.restoredFromPreviousSettings = true;
            this.settings = section;
        }
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected abstract void initializeDefaultSettings();

    public abstract int getPageType();

    public CodeGenWizard getCodegenWizard() {
        return (CodeGenWizard)this.getWizard();
    }
}

