/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.adapters;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class EnumJsonAdapter<T extends Enum<T>>
extends JsonAdapter<T> {
    final Class<T> enumType;
    final String[] nameStrings;
    final T[] constants;
    final JsonReader.Options options;
    final boolean useFallbackValue;
    @Nullable
    final T fallbackValue;

    public static <T extends Enum<T>> EnumJsonAdapter<T> create(Class<T> enumType) {
        return new EnumJsonAdapter<Object>(enumType, null, false);
    }

    public EnumJsonAdapter<T> withUnknownFallback(@Nullable T fallbackValue) {
        return new EnumJsonAdapter<T>(this.enumType, fallbackValue, true);
    }

    EnumJsonAdapter(Class<T> enumType, @Nullable T fallbackValue, boolean useFallbackValue) {
        this.enumType = enumType;
        this.fallbackValue = fallbackValue;
        this.useFallbackValue = useFallbackValue;
        try {
            this.constants = (Enum[])enumType.getEnumConstants();
            this.nameStrings = new String[this.constants.length];
            for (int i = 0; i < this.constants.length; ++i) {
                String name;
                String constantName = ((Enum)this.constants[i]).name();
                Json annotation = enumType.getField(constantName).getAnnotation(Json.class);
                this.nameStrings[i] = name = annotation != null ? annotation.name() : constantName;
            }
            this.options = JsonReader.Options.of((String[])this.nameStrings);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError("Missing field in " + enumType.getName(), e);
        }
    }

    @Nullable
    public T fromJson(JsonReader reader) throws IOException {
        int index = reader.selectString(this.options);
        if (index != -1) {
            return this.constants[index];
        }
        String path = reader.getPath();
        if (!this.useFallbackValue) {
            String name = reader.nextString();
            throw new JsonDataException("Expected one of " + Arrays.asList(this.nameStrings) + " but was " + name + " at path " + path);
        }
        if (reader.peek() != JsonReader.Token.STRING) {
            throw new JsonDataException("Expected a string but was " + reader.peek() + " at path " + path);
        }
        reader.skipValue();
        return this.fallbackValue;
    }

    public void toJson(JsonWriter writer, T value) throws IOException {
        if (value == null) {
            throw new NullPointerException("value was null! Wrap in .nullSafe() to write nullable values.");
        }
        writer.value(this.nameStrings[((Enum)value).ordinal()]);
    }

    public String toString() {
        return "EnumJsonAdapter(" + this.enumType.getName() + ")";
    }
}

