/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.dataflow;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeResource;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.IStorageManager;

public class RTreeResourceFactory
implements IResourceFactory {
    private static final long serialVersionUID = 2L;
    private final IStorageManager storageManager;
    private final ITypeTraits[] typeTraits;
    private final IBinaryComparatorFactory[] comparatorFactories;
    private final IPageManagerFactory pageManagerFactory;
    private final IPrimitiveValueProviderFactory[] valueProviderFactories;
    private final RTreePolicyType rtreePolicyType;
    private final ITypeTraits nullTypeTraits;
    private final INullIntrospector nullIntrospector;

    public RTreeResourceFactory(IStorageManager storageManager, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] comparatorFactories, IPageManagerFactory pageManagerFactory, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) {
        this.storageManager = storageManager;
        this.typeTraits = typeTraits;
        this.comparatorFactories = comparatorFactories;
        this.pageManagerFactory = pageManagerFactory;
        this.valueProviderFactories = valueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.nullTypeTraits = nullTypeTraits;
        this.nullIntrospector = nullIntrospector;
    }

    public IResource createResource(FileReference fileRef) {
        return new RTreeResource(fileRef.getRelativePath(), this.storageManager, this.typeTraits, this.comparatorFactories, this.pageManagerFactory, this.valueProviderFactories, this.rtreePolicyType, this.nullTypeTraits, this.nullIntrospector);
    }
}

