/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.AutoValue_HttpRequestRunnable;
import com.google.api.gax.httpjson.HttpHeadersUtils;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.Temporal;

@AutoValue
abstract class HttpRequestRunnable<RequestT, ResponseT>
implements Runnable {
    HttpRequestRunnable() {
    }

    abstract HttpJsonCallOptions getHttpJsonCallOptions();

    abstract RequestT getRequest();

    abstract ApiMethodDescriptor<RequestT, ResponseT> getApiMethodDescriptor();

    abstract HttpTransport getHttpTransport();

    abstract String getEndpoint();

    abstract JsonFactory getJsonFactory();

    abstract ImmutableList<HttpJsonHeaderEnhancer> getHeaderEnhancers();

    abstract SettableApiFuture<ResponseT> getResponseFuture();

    HttpRequest createHttpRequest() throws IOException {
        EmptyContent jsonHttpContent;
        GenericData tokenRequest = new GenericData();
        HttpRequestFormatter<RequestT> requestFormatter = this.getApiMethodDescriptor().getRequestFormatter();
        Credentials credentials = this.getHttpJsonCallOptions().getCredentials();
        HttpRequestFactory requestFactory = credentials != null ? this.getHttpTransport().createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter(credentials)) : this.getHttpTransport().createRequestFactory();
        String requestBody = requestFormatter.getRequestBody(this.getRequest());
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            this.getJsonFactory().createJsonParser(requestBody).parse((Object)tokenRequest);
            jsonHttpContent = new JsonHttpContent(this.getJsonFactory(), (Object)tokenRequest).setMediaType(new HttpMediaType("application/json"));
        } else {
            jsonHttpContent = new EmptyContent();
        }
        String endpoint = this.normalizeEndpoint(this.getEndpoint());
        GenericUrl url = new GenericUrl(endpoint + requestFormatter.getPath(this.getRequest()));
        Map<String, List<String>> queryParams = requestFormatter.getQueryParamNames(this.getRequest());
        for (Map.Entry<String, List<String>> queryParam : queryParams.entrySet()) {
            if (queryParam.getValue() == null) continue;
            url.set(queryParam.getKey(), queryParam.getValue());
        }
        HttpRequest httpRequest = this.buildRequest(requestFactory, url, (HttpContent)jsonHttpContent);
        Instant deadline = this.getHttpJsonCallOptions().getDeadline();
        if (deadline != null) {
            long readTimeout = Duration.between((Temporal)Instant.now(), (Temporal)deadline).toMillis();
            if (httpRequest.getReadTimeout() > 0 && (long)httpRequest.getReadTimeout() < readTimeout && readTimeout < Integer.MAX_VALUE) {
                httpRequest.setReadTimeout((int)readTimeout);
            }
        }
        for (HttpJsonHeaderEnhancer enhancer : this.getHeaderEnhancers()) {
            enhancer.enhance(httpRequest.getHeaders());
        }
        httpRequest.setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
        return httpRequest;
    }

    private HttpRequest buildRequest(HttpRequestFactory requestFactory, GenericUrl url, HttpContent jsonHttpContent) throws IOException {
        String actualHttpMethod;
        String originalHttpMethod = actualHttpMethod = this.getApiMethodDescriptor().getHttpMethod();
        if ("PATCH".equals(actualHttpMethod)) {
            actualHttpMethod = "POST";
        }
        HttpRequest httpRequest = requestFactory.buildRequest(actualHttpMethod, url, jsonHttpContent);
        if (originalHttpMethod != null && !originalHttpMethod.equals(actualHttpMethod)) {
            HttpHeadersUtils.setHeader(httpRequest.getHeaders(), "X-HTTP-Method-Override", originalHttpMethod);
        }
        return httpRequest;
    }

    private String normalizeEndpoint(String endpoint) {
        String normalized = endpoint;
        if (!normalized.contains("://")) {
            normalized = "https://" + normalized;
        }
        if (normalized.charAt(normalized.length() - 1) != '/') {
            normalized = normalized + '/';
        }
        return normalized;
    }

    @Override
    public void run() {
        try {
            HttpRequest httpRequest = this.createHttpRequest();
            HttpResponse httpResponse = httpRequest.execute();
            if (this.getApiMethodDescriptor().getResponseParser() != null) {
                ResponseT response = this.getApiMethodDescriptor().getResponseParser().parse(httpResponse.getContent(), this.getHttpJsonCallOptions().getTypeRegistry());
                this.getResponseFuture().set(response);
            } else {
                this.getResponseFuture().set(null);
            }
        }
        catch (Exception e) {
            this.getResponseFuture().setException((Throwable)e);
        }
    }

    static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new AutoValue_HttpRequestRunnable.Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>());
    }

    @AutoValue.Builder
    static abstract class Builder<RequestT, ResponseT> {
        Builder() {
        }

        abstract Builder<RequestT, ResponseT> setHttpJsonCallOptions(HttpJsonCallOptions var1);

        abstract Builder<RequestT, ResponseT> setRequest(RequestT var1);

        abstract Builder<RequestT, ResponseT> setApiMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> var1);

        abstract Builder<RequestT, ResponseT> setHttpTransport(HttpTransport var1);

        abstract Builder<RequestT, ResponseT> setEndpoint(String var1);

        abstract Builder<RequestT, ResponseT> setJsonFactory(JsonFactory var1);

        abstract Builder<RequestT, ResponseT> setHeaderEnhancers(List<HttpJsonHeaderEnhancer> var1);

        abstract Builder<RequestT, ResponseT> setResponseFuture(SettableApiFuture<ResponseT> var1);

        abstract HttpRequestRunnable<RequestT, ResponseT> build();
    }
}

