/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;

public final class ValidationUtil {
    private static Pattern tenantIdentifierCharPattern = Pattern.compile("^(?:[A-Z]|[0-9]|[a-z]|-|.)+$");

    public static void validate(String className, Map<String, Object> parameters) {
        ClientLogger logger = new ClientLogger(className);
        ArrayList<String> missing = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() != null) continue;
            missing.add(entry.getKey());
        }
        if (missing.size() > 0) {
            throw logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Must provide non-null values for " + String.join((CharSequence)", ", missing) + " properties in " + className));
        }
    }

    public static void validateAuthHost(String className, String authHost) {
        ClientLogger logger = new ClientLogger(className);
        try {
            new URI(authHost);
        }
        catch (URISyntaxException e) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Must provide a valid URI for authority host.", e));
        }
        if (!authHost.startsWith("https")) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Authority host must use https scheme."));
        }
    }

    public static void validateTenantIdCharacterRange(String className, String id) {
        ClientLogger logger = new ClientLogger(className);
        if (id != null && !tenantIdentifierCharPattern.matcher(id).matches()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid tenant id provided. You can locate your tenant id by following the instructions listed here: https://docs.microsoft.com/partner-center/find-ids-and-domain-names"));
        }
    }

    public static void validateInteractiveBrowserRedirectUrlSetup(String className, Integer port, String redirecrUrl) {
        ClientLogger logger = new ClientLogger(className);
        if (port != null && redirecrUrl != null) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Port and Redirect URL cannot be configured at the same time. Port is deprecated now. Use the redirectUrl setter to specify the redirect URL on the builder."));
        }
    }
}

