/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushProperJoinThroughProduct
implements IAlgebraicRewriteRule {
    private List<LogicalVariable> usedInCond1AndMaps = new ArrayList<LogicalVariable>();
    private List<LogicalVariable> productLeftBranchVars = new ArrayList<LogicalVariable>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        LogicalOperatorTag tag1 = op.getOperatorTag();
        if (tag1 != LogicalOperatorTag.INNERJOIN && tag1 != LogicalOperatorTag.LEFTOUTERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join1 = (AbstractBinaryJoinOperator)op;
        ILogicalExpression cond1 = (ILogicalExpression)join1.getCondition().getValue();
        if (OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)cond1)) {
            return false;
        }
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        while (op2.isMap()) {
            opRef2 = (Mutable)op2.getInputs().get(0);
            op2 = (AbstractLogicalOperator)opRef2.getValue();
        }
        if (op2.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        InnerJoinOperator product = (InnerJoinOperator)op2;
        if (!OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)((ILogicalExpression)product.getCondition().getValue()))) {
            return false;
        }
        this.usedInCond1AndMaps.clear();
        cond1.getUsedVariables(this.usedInCond1AndMaps);
        Mutable opIterRef = (Mutable)op.getInputs().get(0);
        ILogicalOperator opIter = (ILogicalOperator)opIterRef.getValue();
        do {
            VariableUtilities.getUsedVariables((ILogicalOperator)opIter, this.usedInCond1AndMaps);
        } while ((opIter = (ILogicalOperator)(opIterRef = (Mutable)opIter.getInputs().get(0)).getValue()).isMap());
        this.productLeftBranchVars.clear();
        ILogicalOperator opLeft = (ILogicalOperator)((Mutable)op2.getInputs().get(0)).getValue();
        VariableUtilities.getLiveVariables((ILogicalOperator)opLeft, this.productLeftBranchVars);
        if (!OperatorPropertiesUtil.disjoint(this.usedInCond1AndMaps, this.productLeftBranchVars)) {
            return false;
        }
        opIterRef = (Mutable)op.getInputs().get(0);
        opIter = (ILogicalOperator)opIterRef.getValue();
        Mutable op3Ref = (Mutable)product.getInputs().get(1);
        ILogicalOperator op3 = (ILogicalOperator)op3Ref.getValue();
        opRef2.setValue((Object)op3);
        op3Ref.setValue((Object)join1);
        opRef.setValue((Object)product);
        return true;
    }
}

