/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.sort.RunMergingFrameReader;
import org.apache.hyracks.dataflow.std.sort.util.GroupVSizeFrame;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExternalSortRunMerger {
    protected final IHyracksTaskContext ctx;
    private final List<GeneratedRunFileReader> runs;
    private final BitSet currentGenerationRunAvailable;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final RecordDescriptor recordDesc;
    private final int maxMergeWidth;
    private final int topK;
    private List<GeneratedRunFileReader> partialRuns;
    private List<GroupVSizeFrame> inFrames;
    private VSizeFrame outputFrame;
    private boolean first;
    private static final Logger LOGGER = LogManager.getLogger();

    public AbstractExternalSortRunMerger(IHyracksTaskContext ctx, List<GeneratedRunFileReader> runs, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc, int framesLimit) {
        this(ctx, runs, comparators, nmkComputer, recordDesc, framesLimit, Integer.MAX_VALUE);
    }

    AbstractExternalSortRunMerger(IHyracksTaskContext ctx, List<GeneratedRunFileReader> runs, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc, int framesLimit, int topK) {
        this.ctx = ctx;
        this.runs = new LinkedList<GeneratedRunFileReader>(runs);
        this.currentGenerationRunAvailable = new BitSet(runs.size());
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        this.recordDesc = recordDesc;
        this.maxMergeWidth = framesLimit - 1;
        this.topK = topK;
        this.first = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void process(IFrameWriter finalWriter) throws HyracksDataException {
        try {
            void var3_5;
            this.createReusableObjects();
            int stop = this.runs.size();
            this.currentGenerationRunAvailable.set(0, stop);
            boolean bl = true;
            while (true) {
                GeneratedRunFileReader reader;
                int unUsed = AbstractExternalSortRunMerger.selectPartialRuns(this.maxMergeWidth * this.ctx.getInitialFrameSize(), this.runs, this.partialRuns, this.currentGenerationRunAvailable, stop);
                this.prepareFrames(unUsed, this.inFrames, this.partialRuns);
                if (this.currentGenerationRunAvailable.isEmpty() && stop >= this.runs.size()) break;
                if (this.partialRuns.size() == 1) {
                    if (!this.currentGenerationRunAvailable.isEmpty()) {
                        throw new HyracksDataException("The record is too big to put into the merging frame, please allocate more sorting memory");
                    }
                    reader = this.partialRuns.get(0);
                } else {
                    RunFileWriter mergeFileWriter = this.prepareIntermediateMergeRunFile();
                    try (IFrameWriter mergeResultWriter = this.prepareIntermediateMergeResultWriter(mergeFileWriter);){
                        mergeResultWriter.open();
                        this.merge(mergeResultWriter, this.partialRuns);
                    }
                    reader = mergeFileWriter.createDeleteOnCloseReader();
                }
                this.runs.add(reader);
                if (!this.currentGenerationRunAvailable.isEmpty()) continue;
                ++var3_5;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("generated runs:" + stop);
                }
                this.runs.subList(0, stop).clear();
                this.currentGenerationRunAvailable.clear();
                this.currentGenerationRunAvailable.set(0, this.runs.size());
                stop = this.runs.size();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("final runs: {}", (Object)stop);
                LOGGER.debug("number of passes: " + (int)var3_5);
            }
            this.merge(finalWriter, this.partialRuns);
        }
        finally {
            for (RunFileReader runFileReader : this.runs) {
                try {
                    runFileReader.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static int selectPartialRuns(int argBudget, List<GeneratedRunFileReader> runs, List<GeneratedRunFileReader> partialRuns, BitSet runAvailable, int stop) {
        partialRuns.clear();
        int budget = argBudget;
        int maxFrameSizeOfGenRun = 0;
        int nextRunId = runAvailable.nextSetBit(0);
        while (budget > 0 && nextRunId >= 0 && nextRunId < stop) {
            int runFrameSize = runs.get(nextRunId).getMaxFrameSize();
            if (budget - runFrameSize >= 0) {
                partialRuns.add(runs.get(nextRunId));
                budget -= runFrameSize;
                runAvailable.clear(nextRunId);
                maxFrameSizeOfGenRun = Math.max(runFrameSize, maxFrameSizeOfGenRun);
            }
            nextRunId = runAvailable.nextSetBit(nextRunId + 1);
        }
        return budget;
    }

    private void prepareFrames(int extraFreeMem, List<GroupVSizeFrame> inFrames, List<GeneratedRunFileReader> partialRuns) throws HyracksDataException {
        int i;
        if (extraFreeMem > 0 && partialRuns.size() > 1) {
            int i2;
            int extraFrames = extraFreeMem / this.ctx.getInitialFrameSize();
            int avg = extraFrames / partialRuns.size() * this.ctx.getInitialFrameSize();
            int residue = extraFrames % partialRuns.size();
            for (i2 = 0; i2 < residue; ++i2) {
                partialRuns.get(i2).updateSize(Math.min(Integer.MAX_VALUE, partialRuns.get(i2).getMaxFrameSize() + avg + this.ctx.getInitialFrameSize()));
            }
            for (i2 = residue; i2 < partialRuns.size() && avg > 0; ++i2) {
                partialRuns.get(i2).updateSize(Math.min(Integer.MAX_VALUE, partialRuns.get(i2).getMaxFrameSize() + avg));
            }
        }
        if (inFrames.size() > partialRuns.size()) {
            inFrames.subList(partialRuns.size(), inFrames.size()).clear();
        }
        for (i = 0; i < inFrames.size(); ++i) {
            inFrames.get(i).resize(partialRuns.get(i).getMaxFrameSize());
        }
        while (i < partialRuns.size()) {
            inFrames.add(new GroupVSizeFrame((IHyracksCommonContext)this.ctx, partialRuns.get(i).getMaxFrameSize()));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(IFrameWriter writer, List<GeneratedRunFileReader> partialRuns) throws HyracksDataException {
        RunMergingFrameReader merger = new RunMergingFrameReader(this.ctx, partialRuns, this.inFrames, this.getSortFields(), this.comparators, this.nmkComputer, this.recordDesc, this.topK);
        int io = 0;
        merger.open();
        try {
            while (merger.nextFrame((IFrame)this.outputFrame)) {
                FrameUtils.flushFrame((ByteBuffer)this.outputFrame.getBuffer(), (IFrameWriter)writer);
                ++io;
            }
        }
        finally {
            merger.close();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Output " + io + " frames");
            }
        }
    }

    public void reset(List<GeneratedRunFileReader> newRuns) {
        this.runs.clear();
        this.runs.addAll(newRuns);
        this.currentGenerationRunAvailable.clear();
    }

    private void createReusableObjects() throws HyracksDataException {
        if (this.first) {
            this.first = false;
            this.inFrames = new ArrayList<GroupVSizeFrame>(this.maxMergeWidth);
            this.outputFrame = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            this.partialRuns = new ArrayList<GeneratedRunFileReader>(this.maxMergeWidth);
        }
    }

    public abstract IFrameWriter prepareSkipMergingFinalResultWriter(IFrameWriter var1) throws HyracksDataException;

    protected abstract RunFileWriter prepareIntermediateMergeRunFile() throws HyracksDataException;

    protected abstract IFrameWriter prepareIntermediateMergeResultWriter(RunFileWriter var1) throws HyracksDataException;

    public abstract IFrameWriter prepareFinalMergeResultWriter(IFrameWriter var1) throws HyracksDataException;

    protected abstract int[] getSortFields();
}

