/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class LimitOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int outputLimit;

    public LimitOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor rDesc, int outputLimit) {
        super(spec, 1, 1);
        this.outRecDescs[0] = rDesc;
        this.outputLimit = outputLimit;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private FrameTupleAccessor fta;
            private int currentSize;
            private boolean finished;

            public void open() throws HyracksDataException {
                this.fta = new FrameTupleAccessor(LimitOperatorDescriptor.this.outRecDescs[0]);
                this.currentSize = 0;
                this.finished = false;
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                if (!this.finished) {
                    this.fta.reset(buffer);
                    int count = this.fta.getTupleCount();
                    if (this.currentSize + count > LimitOperatorDescriptor.this.outputLimit) {
                        FrameTupleAppender partialAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
                        int copyCount = LimitOperatorDescriptor.this.outputLimit - this.currentSize;
                        for (int i = 0; i < copyCount; ++i) {
                            FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)partialAppender, (IFrameTupleAccessor)this.fta, (int)i);
                            ++this.currentSize;
                        }
                        partialAppender.write(this.writer, false);
                        this.finished = true;
                    } else {
                        FrameUtils.flushFrame((ByteBuffer)buffer, (IFrameWriter)this.writer);
                        this.currentSize += count;
                    }
                }
            }

            public void fail() throws HyracksDataException {
                this.writer.fail();
            }

            public void close() throws HyracksDataException {
                this.writer.close();
            }

            public void flush() throws HyracksDataException {
                this.writer.flush();
            }
        };
    }
}

