/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.app.message.StorageCleanupRequestMessage;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalRecoveryManager
implements IGlobalRecoveryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IStorageComponentProvider componentProvider;
    protected final ICCServiceContext serviceCtx;
    protected final IHyracksClientConnection hcc;
    protected volatile boolean recoveryCompleted;
    protected volatile boolean recovering;
    protected Future<?> recoveryFuture;

    public GlobalRecoveryManager(ICCServiceContext serviceCtx, IHyracksClientConnection hcc, IStorageComponentProvider componentProvider) {
        this.serviceCtx = serviceCtx;
        this.hcc = hcc;
        this.componentProvider = componentProvider;
    }

    public Set<IClusterManagementWork> notifyNodeFailure(Collection<String> deadNodeIds) {
        return Collections.emptySet();
    }

    public Set<IClusterManagementWork> notifyNodeJoin(String joinedNodeId) {
        return Collections.emptySet();
    }

    private void executeHyracksJob(JobSpecification spec) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = this.hcc.startJob(spec);
        this.hcc.waitForCompletion(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGlobalRecovery(ICcApplicationContext appCtx) {
        if (!this.recoveryCompleted && !this.recovering) {
            GlobalRecoveryManager globalRecoveryManager = this;
            synchronized (globalRecoveryManager) {
                if (!this.recovering) {
                    this.recovering = true;
                    this.recoveryFuture = this.serviceCtx.getControllerService().getExecutor().submit(() -> {
                        try {
                            this.recover(appCtx);
                        }
                        catch (Throwable e) {
                            try {
                                LOGGER.fatal("Global recovery failed. Shutting down...", e);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            ExitUtil.exit((int)3);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recover(ICcApplicationContext appCtx) throws Exception {
        LOGGER.info("Starting Global Recovery");
        MetadataManager.INSTANCE.init();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        if (appCtx.getStorageProperties().isStorageGlobalCleanup()) {
            int storageGlobalCleanupTimeout = appCtx.getStorageProperties().getStorageGlobalCleanupTimeout();
            this.performGlobalStorageCleanup(mdTxnCtx, storageGlobalCleanupTimeout);
        }
        mdTxnCtx = this.doRecovery(appCtx, mdTxnCtx);
        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        this.recoveryCompleted = true;
        this.recovering = false;
        GlobalRecoveryManager globalRecoveryManager = this;
        synchronized (globalRecoveryManager) {
            this.recoveryFuture = null;
        }
        LOGGER.info("Global Recovery Completed. Refreshing cluster state...");
        appCtx.getClusterStateManager().refreshState();
    }

    protected void performGlobalStorageCleanup(MetadataTransactionContext mdTxnCtx, int storageGlobalCleanupTimeoutSecs) throws Exception {
        List dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
        IntOpenHashSet validDatasetIds = new IntOpenHashSet();
        for (Dataverse dataverse : dataverses) {
            List dataverseDatasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
            dataverseDatasets.stream().filter(DatasetUtil::isNotView).mapToInt(Dataset::getDatasetId).forEach(arg_0 -> ((IntOpenHashSet)validDatasetIds).add(arg_0));
        }
        ICcApplicationContext ccAppCtx = (ICcApplicationContext)this.serviceCtx.getApplicationContext();
        ArrayList<String> ncs = new ArrayList<String>(ccAppCtx.getClusterStateManager().getParticipantNodes());
        CCMessageBroker messageBroker = (CCMessageBroker)ccAppCtx.getServiceContext().getMessageBroker();
        long reqId = messageBroker.newRequestId();
        ArrayList<StorageCleanupRequestMessage> requests = new ArrayList<StorageCleanupRequestMessage>();
        for (int i = 0; i < ncs.size(); ++i) {
            requests.add(new StorageCleanupRequestMessage(reqId, validDatasetIds));
        }
        messageBroker.sendSyncRequestToNCs(reqId, ncs, requests, TimeUnit.SECONDS.toMillis(storageGlobalCleanupTimeoutSecs), false);
    }

    protected MetadataTransactionContext doRecovery(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx) throws Exception {
        for (Dataverse dataverse : MetadataManager.INSTANCE.getDataverses(mdTxnCtx)) {
            mdTxnCtx = this.recoverDatasets(appCtx, mdTxnCtx, dataverse);
            MetadataManager.INSTANCE.getDataverse(mdTxnCtx, dataverse.getDataverseName());
        }
        return mdTxnCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateChange(IClusterManagementWork.ClusterState newState) {
        GlobalRecoveryManager globalRecoveryManager = this;
        synchronized (globalRecoveryManager) {
            if (this.recovering && newState == IClusterManagementWork.ClusterState.UNUSABLE && this.recoveryFuture != null) {
                this.recoveryFuture.cancel(true);
            }
        }
        if (newState != IClusterManagementWork.ClusterState.ACTIVE && newState != IClusterManagementWork.ClusterState.RECOVERING) {
            this.recoveryCompleted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataTransactionContext recoverDatasets(ICcApplicationContext appCtx, MetadataTransactionContext mdTxnCtx, Dataverse dataverse) throws Exception {
        if (!dataverse.getDataverseName().equals((Object)MetadataConstants.METADATA_DATAVERSE_NAME)) {
            MetadataProvider metadataProvider = MetadataProvider.create((ICcApplicationContext)appCtx, (Dataverse)dataverse);
            try {
                List datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverse.getDataverseName());
                for (Dataset dataset : datasets) {
                    List files;
                    if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) continue;
                    List indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName());
                    ExternalDatasetDetails dsd = (ExternalDatasetDetails)dataset.getDatasetDetails();
                    DatasetConfig.TransactionState datasetState = dsd.getState();
                    if (!indexes.isEmpty()) {
                        if (datasetState == DatasetConfig.TransactionState.BEGIN) {
                            files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                            for (ExternalFile file : files) {
                                if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.NO_OP) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            }
                        }
                        metadataProvider.setMetadataTxnContext(mdTxnCtx);
                        JobSpecification jobSpec = ExternalIndexingOperations.buildAbortOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                        this.executeHyracksJob(jobSpec);
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                        continue;
                    }
                    if (datasetState != DatasetConfig.TransactionState.READY_TO_COMMIT) continue;
                    files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                    metadataProvider.setMetadataTxnContext(mdTxnCtx);
                    JobSpecification jobSpec = ExternalIndexingOperations.buildRecoverOp((Dataset)dataset, (List)indexes, (MetadataProvider)metadataProvider);
                    this.executeHyracksJob(jobSpec);
                    for (ExternalFile file : files) {
                        if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP) {
                            MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                            file.setPendingOp(DatasetConfig.ExternalFilePendingOp.NO_OP);
                            MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, file);
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.DROP_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                break;
                            }
                        } else if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.APPEND_OP) {
                            for (ExternalFile originalFile : files) {
                                if (!originalFile.getFileName().equals(file.getFileName())) continue;
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                                MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, originalFile);
                                originalFile.setSize(file.getSize());
                                MetadataManager.INSTANCE.addExternalFile(mdTxnCtx, originalFile);
                            }
                        }
                        ((ExternalDatasetDetails)dataset.getDatasetDetails()).setState(DatasetConfig.TransactionState.COMMIT);
                        MetadataManager.INSTANCE.updateDataset(mdTxnCtx, dataset);
                        MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
                        mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
                    }
                }
            }
            finally {
                metadataProvider.getLocks().unlock();
            }
        }
        return mdTxnCtx;
    }

    public boolean isRecoveryCompleted() {
        return this.recoveryCompleted;
    }
}

